package sti.dao.acompanhamento;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

import sti.dto.acompanhamento.AcompanhamentoListaDTO;

import dao.DAOBase;
import dto.ConteudoDTO;

public class AcompanhamentoQuestoesListasDAO extends DAOBase{
	
	//CONTEUDOS
	public Collection buscarConteudosDasQuestoesDasListasFeitasPeloAluno(Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre, String dataFimSemestre) throws SQLException{
		String SQL_CONTEUDOS_DAS_QUESTOES_DAS_LISTAS_FEITAS_PELO_ALUNO = 
		"SELECT distinct q.idConteudo,mc.descricao FROM bdqQuestao q, bdqAluno_RespostaLista r,maiorConteudo mc WHERE q.idquestao = r.idquestao and r.chavePessoa = "+chavePessoa+" and q.idConteudo = mc.idConteudo and q.idDisciplina = mc.idDisciplina and q.idDisciplina = "+idDisciplina+" and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY mc.ordem;";
		return executaQueryConteudo(SQL_CONTEUDOS_DAS_QUESTOES_DAS_LISTAS_FEITAS_PELO_ALUNO);
	}
	public Collection buscarConteudosDasQuestoesDasListasFeitasPeloAluno(Integer idLista,Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre, String dataFimSemestre) throws SQLException{
		String SQL_CONTEUDOS_DAS_QUESTOES_DE_UMA_LISTA_FEITA_PELO_ALUNO = 
		"SELECT distinct q.idConteudo,mc.descricao FROM bdqQuestao q, bdqAluno_RespostaLista r,maiorConteudo mc WHERE q.idquestao = r.idquestao and r.chavePessoa = "+chavePessoa+" and q.idConteudo = mc.idConteudo and q.idDisciplina = mc.idDisciplina and q.idDisciplina = "+idDisciplina+" and r.idLista = "+idLista+" and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"'  ORDER BY mc.ordem;";
		return executaQueryConteudo(SQL_CONTEUDOS_DAS_QUESTOES_DE_UMA_LISTA_FEITA_PELO_ALUNO);
	}
	private Collection executaQueryConteudo(String sql) throws SQLException {
		System.out.println("Executando na DAO listas Conteudo: "+sql);
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(sql);
		ConteudoDTO dto;
		Collection col = new ArrayList();
		
		while(rs.next()){
			dto = new ConteudoDTO();
			dto.setIdConteudo(new Integer(rs.getInt("idConteudo")));
			dto.setDescricao(rs.getString("descricao"));
			col.add(dto);
		}
		rs.close();
		stm.close();
		return col;

	}
	
    // VERDADEIRAS OU FALSAS
	public Collection buscarQuestoesListasVouF(Integer chavePessoa, Integer idDisciplina, String dataInicioSemestre,String dataFimSemestre,boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_VOUF =
		"SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo,q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqVouF v WHERE q.idquestao = r.idquestao and r.idquestao = v.idquestao and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" v.resposta and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_VOUF);
	}
	public Collection buscarQuestoesListasVouF(Integer idLista, Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_VOUF_DE_UMA_LISTA =
		"SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo,q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqVouF v WHERE q.idquestao = r.idquestao and r.idquestao = v.idquestao and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" v.resposta and r.idLista = "+idLista+" and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_VOUF_DE_UMA_LISTA);
	}
    // VERDADEIRAS OU FALSAS por conteudo	
	public Collection buscarQuestoesListasVouFPorConteudo(Integer chavePessoa, Integer idDisciplina,Integer idConteudo, String dataInicioSemestre,String dataFimSemestre,boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_VOUF =
		"SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo,q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqVouF v WHERE q.idquestao = r.idquestao and r.idquestao = v.idquestao and q.iddisciplina = "+idDisciplina+" and q.idConteudo = "+idConteudo+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" v.resposta and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_VOUF);
	}
	public Collection buscarQuestoesListasVouFPorConteudo(Integer idLista, Integer chavePessoa, Integer idDisciplina,Integer idConteudo,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_VOUF_DE_UMA_LISTA =
		"SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo,q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqVouF v WHERE q.idquestao = r.idquestao and r.idquestao = v.idquestao and q.iddisciplina = "+idDisciplina+" and q.idConteudo = "+idConteudo+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" v.resposta and r.idLista = "+idLista+" and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_VOUF_DE_UMA_LISTA);
	}
	//ESCOLHAS 
	public Collection buscarQuestoesListasEscolhas(Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_ECOLHAS
		= "SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo, q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqEscolhas e WHERE q.idquestao = r.idquestao and r.idquestao = e.idquestao and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" e.resposta and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_ECOLHAS);
	}
	public Collection buscarQuestoesListasEscolhas(Integer idLista, Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_ECOLHAS_DE_UMA_LISTA
		= "SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo, q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqEscolhas e WHERE q.idquestao = r.idquestao and r.idquestao = e.idquestao and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" e.resposta and r.idLista = "+idLista+" and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_ECOLHAS_DE_UMA_LISTA);
	}
	//ESCOLHAS por conteudo
	public Collection buscarQuestoesListasEscolhasPorConteudo(Integer chavePessoa, Integer idDisciplina,Integer idConteudo,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_ECOLHAS
		= "SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo, q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqEscolhas e WHERE q.idquestao = r.idquestao and r.idquestao = e.idquestao and q.iddisciplina = "+idDisciplina+" and q.idConteudo = "+idConteudo+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" e.resposta and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_ECOLHAS);
	}
	public Collection buscarQuestoesListasEscolhasPorConteudo(Integer idLista, Integer chavePessoa, Integer idDisciplina,Integer idConteudo,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_ECOLHAS_DE_UMA_LISTA
		= "SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo, q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqEscolhas e WHERE q.idquestao = r.idquestao and r.idquestao = e.idquestao and q.iddisciplina = "+idDisciplina+" and q.idConteudo = "+idConteudo+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" e.resposta and r.idLista = "+idLista+" and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_ECOLHAS_DE_UMA_LISTA);
	}
	//MULTIPLAS
	public Collection buscarQuestoesListasMultipla(Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_MULTIPLA
		= "SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo, q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqMultipla m WHERE q.idquestao = r.idquestao and r.idquestao = m.idquestao and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" m.resposta and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idLista, r.chavepessoa, q.iddisciplina;";
		
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_MULTIPLA);
	}
	public Collection buscarQuestoesListasMultipla(Integer idLista, Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_MULTIPLA_DE_UMA_LISTA
		= "SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo, q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqMultipla m WHERE q.idquestao = r.idquestao and r.idquestao = m.idquestao and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" m.resposta and r.idLista = "+idLista+" and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_MULTIPLA_DE_UMA_LISTA);
	}
	//MULTIPLAS por conteudo
	public Collection buscarQuestoesListasMultiplaPorConteudo(Integer chavePessoa, Integer idDisciplina,Integer idConteudo,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_MULTIPLA
		= "SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo, q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqMultipla m WHERE q.idquestao = r.idquestao and r.idquestao = m.idquestao and q.iddisciplina = "+idDisciplina+" and q.idConteudo = "+idConteudo+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" m.resposta and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idLista, r.chavepessoa, q.iddisciplina;";
		
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_MULTIPLA);
	}
	public Collection buscarQuestoesListasMultiplaPorConteudo(Integer idLista, Integer chavePessoa, Integer idDisciplina,Integer idConteudo,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_MULTIPLA_DE_UMA_LISTA
		= "SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo, q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqMultipla m WHERE q.idquestao = r.idquestao and r.idquestao = m.idquestao and q.iddisciplina = "+idDisciplina+" and q.idConteudo = "+idConteudo+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" m.resposta and r.idLista = "+idLista+" and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_MULTIPLA_DE_UMA_LISTA);
	}
	//LACUNAS
	public Collection buscarQuestoesListasLacunas(Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_LACUNAS
		="SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo,q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqLacuna l, bdqRespostaLista_Aberta a WHERE q.idquestao = r.idquestao and r.idquestao = l.idquestao and l.idquestao = a.idquestao and r.chavepessoa = a.chavepessoa and r.idlista = a.idlista and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and r.solucao = 'Z' and a.correcao "+erradasOuErradas(certaOuErrada)+" 'C' and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_LACUNAS);
	}
	
	public Collection buscarQuestoesListasLacunas(Integer idLista, Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_LACUNAS_DE_UMA_LISTA
		="SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo,q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqLacuna l, bdqRespostaLista_Aberta a WHERE q.idquestao = r.idquestao and r.idquestao = l.idquestao and l.idquestao = a.idquestao and r.chavepessoa = a.chavepessoa and r.idlista = a.idlista and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and r.solucao = 'Z' and a.correcao "+erradasOuErradas(certaOuErrada)+" 'C' and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' and r.idLista = "+idLista+" ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_LACUNAS_DE_UMA_LISTA);
	}
	//LACUNAS por conteudo
	public Collection buscarQuestoesListasLacunasPorConteudo(Integer chavePessoa, Integer idDisciplina,Integer idConteudo, String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_LACUNAS
		="SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo,q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqLacuna l, bdqRespostaLista_Aberta a WHERE q.idquestao = r.idquestao and r.idquestao = l.idquestao and l.idquestao = a.idquestao and r.chavepessoa = a.chavepessoa and r.idlista = a.idlista and q.iddisciplina = "+idDisciplina+" and q.idConteudo = "+idConteudo+" and r.chavepessoa = "+chavePessoa+" and r.solucao = 'Z' and a.correcao "+erradasOuErradas(certaOuErrada)+" 'C' and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_LACUNAS);
	}
	
	public Collection buscarQuestoesListasLacunasPorConteudo(Integer idLista, Integer chavePessoa, Integer idDisciplina,Integer idConteudo,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_LACUNAS_DE_UMA_LISTA
		="SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo,q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqLacuna l, bdqRespostaLista_Aberta a WHERE q.idquestao = r.idquestao and r.idquestao = l.idquestao and l.idquestao = a.idquestao and r.chavepessoa = a.chavepessoa and r.idlista = a.idlista and q.iddisciplina = "+idDisciplina+" and q.idConteudo = "+idConteudo+" and r.chavepessoa = "+chavePessoa+" and r.solucao = 'Z' and a.correcao "+erradasOuErradas(certaOuErrada)+" 'C' and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' and r.idLista = "+idLista+" ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_LACUNAS_DE_UMA_LISTA);
	}
	//ABERTAS
	public Collection buscarQuestoesListasAbertas(Integer chavePessoa, Integer idDisciplina, String dataInicioSemestre,String dataFimSemestre,boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_ABERTAS
		="SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo,q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqAberta d, bdqRespostaLista_Aberta a WHERE q.idquestao = r.idquestao and r.idquestao = d.idquestao and d.idquestao = a.idquestao and r.chavepessoa = a.chavepessoa and r.idlista = a.idlista and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and r.solucao = 'X' and a.correcao "+erradasOuErradas(certaOuErrada)+" 'C' and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_ABERTAS);
	}
	public Collection buscarQuestoesListasAbertas(Integer idLista, Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_ABERTAS_DE_UMA_LISTA
		="SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo,q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqAberta d, bdqRespostaLista_Aberta a WHERE q.idquestao = r.idquestao and r.idquestao = d.idquestao and d.idquestao = a.idquestao and r.chavepessoa = a.chavepessoa and r.idlista = a.idlista and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and r.solucao = 'X' and a.correcao "+erradasOuErradas(certaOuErrada)+" 'C' and r.idLista = "+idLista+" and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_ABERTAS_DE_UMA_LISTA);
	}
	//ABERTAS por conteudo
	public Collection buscarQuestoesListasAbertasPorConteudo(Integer chavePessoa, Integer idDisciplina,Integer idConteudo, String dataInicioSemestre,String dataFimSemestre,boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_ABERTAS
		="SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo,q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqAberta d, bdqRespostaLista_Aberta a WHERE q.idquestao = r.idquestao and r.idquestao = d.idquestao and d.idquestao = a.idquestao and r.chavepessoa = a.chavepessoa and r.idlista = a.idlista and q.iddisciplina = "+idDisciplina+" and q.idConteudo = "+idConteudo+" and r.chavepessoa = "+chavePessoa+" and r.solucao = 'X' and a.correcao "+erradasOuErradas(certaOuErrada)+" 'C' and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_LISTAS_CERTAS_OU_ERRADAS_ABERTAS);
	}
	public Collection buscarQuestoesListasAbertasPorConteudo(Integer idLista, Integer chavePessoa, Integer idDisciplina , Integer idConteudo,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_ABERTAS_DE_UMA_LISTA
		="SELECT r.idlista, q.iddisciplina, q.idquestao, q.idconteudo,q.dificuldade, q.categoria, q.tipoquestao,r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaLista r, bdqAberta d, bdqRespostaLista_Aberta a WHERE q.idquestao = r.idquestao and r.idquestao = d.idquestao and d.idquestao = a.idquestao and r.chavepessoa = a.chavepessoa and r.idlista = a.idlista and q.iddisciplina = "+idDisciplina+" and q.idConteudo = "+idConteudo+" and r.chavepessoa = "+chavePessoa+" and r.solucao = 'X' and a.correcao "+erradasOuErradas(certaOuErrada)+" 'C' and r.idLista = "+idLista+" and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"' ORDER BY r.idlista, r.chavepessoa, q.iddisciplina;";
		return executaQueryParaQuestoesLista(SQL_BUSCA_QUESTOES_CERTAS_OU_ERRADAS_ABERTAS_DE_UMA_LISTA);
	}
	private Collection executaQueryParaQuestoesLista(String sql) throws SQLException{
		System.out.println("Executando o seguinte SQL na DAO das Listas: "+sql);
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(sql);
		AcompanhamentoListaDTO dto;
		Collection col = new ArrayList();
		
		while(rs.next()){
			dto = new AcompanhamentoListaDTO();
			putDTO(rs,dto);
			col.add(dto);
		}
		rs.close();
		stm.close();
		return col;
	}
	
	
	private void putDTO(ResultSet rs, AcompanhamentoListaDTO dto) throws SQLException{
		dto.getQuestaoDTO().setIdQuestao(new Integer(rs.getInt("idQuestao")));
		dto.getQuestaoDTO().setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
		dto.getQuestaoDTO().setIdConteudo(new Integer(rs.getInt("idConteudo")));
		dto.getQuestaoDTO().setDificuldade(rs.getString("dificuldade"));
		dto.getQuestaoDTO().setCategoria(rs.getString("categoria"));
		dto.getQuestaoDTO().setTipoQuestao(rs.getString("tipoQuestao"));
		dto.setDtSolucao(rs.getDate("dtSolucao"));
		dto.setIdLista(new Integer(rs.getInt("idLista")));
	}
	
	private String erradasOuErradas(boolean certa){
		String sinal;
		if(certa)
			sinal = "="; //pegara as questoes certas
		else
			sinal = "<>"; //pegara as questoes erradas
		return sinal;
	}

}
