package sti.dao.acompanhamento;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

import sti.dto.acompanhamento.AcompanhamentoDTOSTI;
import sti.dto.lista.ListaDTO;
import sti.dto.turma.AlunoDaTurmaDTO;
import sti.dto.turma.TurmaDTO;
import dao.DAOBase;
import dto.AlunoDTO;
import dto.DisciplinaDTO;
import dto.ProfessorDTO;

public class STIAcompanhamentoDAO extends DAOBase{
	
	private static String SQL_BUSCAR_ACOMPANHAMENTO = "select * from stiAcompanhamento a where a.idDisciplina = ? and a.ano = ? and a.semestre = ? and a.chavePessoaAluno = ?";
	private static String SQL_INSERT_ACOMPANHAMENTO = "INSERT INTO stiAcompanhamento values (?,?,?,?,?)";
	private static String SQL_LISTA_CURSO_DISCIPLINAS_MINISTRADA_PELO_PROFESSOR = "SELECT distinct md.idDisciplina,md.nomeDisciplina,mc.codigoCurso,mc.nomeCurso FROM maiorTurma mt, maiorCurso mc,maiorDisciplina md where mt.chavePessoaProfessor = ? and ano = ? and semestre = ? and mt.idDisciplina = md.idDisciplina and mc.codigoCurso = mt.codigoCurso order by md.nomeDisciplina;";
	private static String SQL_LISTA_CURSO_DISCIPLINAS_MONITORADAS_PELO_MONITOR = "SELECT * FROM maiorMonitor m,maiorCurso mc, maiorCurso_Disciplina mcd, maiorDisciplina md where m.idDisciplina = mcd.idDisciplina and m.chavePessoa = ? and m.ano = ? and m.semestre = ? and md.idDisciplina = m.idDisciplina and mc.codigoCurso = mcd.codigoCurso;";
	private static String SQL_LISTA_TURMAS_DA_DISCIPLINA = "SELECT m.codigoTurma,mc.codigoCurso,mc.nomeCurso,md.idDisciplina,md.nomeDisciplina,mp.chavePessoa,mp.nomePessoa,mp.apelido FROM maiorTurma m, maiorPessoa mp, maiorCurso mc,maiorDisciplina md where m.idDisciplina = ? and m.codigoCurso = ? and m.ano = ? and m.semestre = ? and mp.chavePessoa = m.chavePessoaProfessor and mp.situacao = 'a' and mc.codigoCurso = m.codigoCurso and m.idDisciplina = md.idDisciplina order by m.codigoTurma;";
	private static String SQL_LISTA_ALUNOS_DA_TURMA = "SELECT mat.codigoTurma, mat.codigoCurso, mat.idDisciplina, mat.chavePessoaAluno, mp.nomePessoa, mp.email,ma.matricula FROM maiorTurma_Aluno mat, maiorPessoa mp, maiorAluno ma where mat.codigoCurso = ? AND mat.idDisciplina = ? and mat.ano = ? and mat.semestre = ? and mat.chavePessoaAluno = mp.chavePessoa and mp.chavePessoa = ma.chavePessoa and mat.codigoTurma = ? order by mp.nomePessoa";
	private static String SQL_BUSCA_PROFESSOR_DA_TURMA = "SELECT mat.chavePessoaProfessor, mp.nomePessoa, mp.email , ma.maiorTitulo FROM maiorTurma mat, maiorPessoa mp, maiorProfessor ma where mat.codigoCurso = ? AND mat.idDisciplina = ? and mat.ano = ? and mat.semestre = ? and mat.codigoTurma = ? and mat.chavePessoaProfessor = mp.chavePessoa and mp.chavePessoa = ma.chavePessoa;";
	private static String SQL_LISTA_DISCIPLINAS_DO_ALUNO = "SELECT b.idDisciplina, b.nomeDisciplina, b.cargaHoraria, b.objetivo FROM maiorTurma_Aluno a, maiorDisciplina b WHERE a.chavePessoaAluno = ? and a.idDisciplina = b.idDisciplina order by b.nomeDisciplina;";
	private static String SQL_LISTA_TURMAS_DO_ALUNO = "SELECT * FROM maiorTurma_Aluno m where m.chavePessoaAluno = ? and ano = ? and semestre = ?;";
	private static String SQL_LISTAR_QUESTOES_FEITAS_PELO_ALUNO = "SELECT DISTINCT listaFeita.idlista,listaFeita.chavePessoa, lista.tituloLista,lista.categoria, listaDaTurma.dtLimiteEntrega FROM bdqAluno_RespostaLista listaFeita , bdqLista lista, bdqLista_Turma listaDaTurma  where listaFeita.chavePessoa = ? and listaFeita.idLista = lista.idLista and listaDaTurma.idLista = listaFeita.idLista and listaDaTurma.codigoCurso = ? and listaDaTurma.idDisciplina = ? and listaDaTurma.codigoTurma = ? AND listaDaTurma.ano = ? and listaDaTurma.semestre = ? order by lista.tituloLista;";
	private static String SQL_BUSCA_ALUNO_DA_TURMA = "SELECT mat.codigoTurma, mat.codigoCurso, mat.idDisciplina, mat.chavePessoaAluno, mp.nomePessoa, mp.email,ma.matricula FROM maiorTurma_Aluno mat, maiorPessoa mp, maiorAluno ma where mat.codigoCurso = ? AND mat.idDisciplina = ? and mat.ano = ? and mat.semestre = ? and mat.chavePessoaAluno = mp.chavePessoa and mp.chavePessoa = ma.chavePessoa and mat.codigoTurma = ? AND mat.chavePessoaAluno = ?";
	public Collection buscaDisciplinasDoAluno(Integer chavePessoaAluno) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_LISTA_DISCIPLINAS_DO_ALUNO);
		ps.setInt(1,chavePessoaAluno.intValue());
		ResultSet rs = ps.executeQuery();
		DisciplinaDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new DisciplinaDTO();
			putDisciplinaDTO(rs,dto);
			col.add(dto);
		}

		return col;
	}


	public Collection listaDisciplinasMinistradasPeloProfessor(Integer chavePessoaProfessor,int ano,int semestre) throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_LISTA_CURSO_DISCIPLINAS_MINISTRADA_PELO_PROFESSOR);
		ps.setInt(1,chavePessoaProfessor.intValue());
		ps.setInt(2,ano);
		ps.setInt(3,semestre);
		ResultSet rs = ps.executeQuery();
		TurmaDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new TurmaDTO();
			dto.getDiciplinaDTO().setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
			dto.getDiciplinaDTO().setNomeDisciplina(rs.getString("nomeDisciplina"));
			dto.getCursoDTO().setCodigoCurso(new Integer(rs.getInt("codigoCurso")));
			dto.getCursoDTO().setNomeCurso(rs.getString("nomeCurso"));
			col.add(dto);
		}
		
		return col;
	}
	
	public Collection buscarTurmasDaDisciplina(Integer idDisciplina, Integer codigoCurso, int anoSystem, int semestreSystem) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_LISTA_TURMAS_DA_DISCIPLINA);
		ps.setInt(1,idDisciplina.intValue());
		ps.setInt(2,codigoCurso.intValue());
		ps.setInt(3,anoSystem);
		ps.setInt(4,semestreSystem);
		ResultSet rs = ps.executeQuery();
		TurmaDTO dto;
		Collection col = new ArrayList();
		
		while(rs.next()){
			dto = new TurmaDTO();
			dto.setCodigoTurma(rs.getString("codigoTurma"));
			dto.getCursoDTO().setCodigoCurso(new Integer(rs.getInt("codigoCurso")));
			dto.getCursoDTO().setNomeCurso(rs.getString("nomeCurso"));
			dto.getDiciplinaDTO().setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
			dto.getDiciplinaDTO().setNomeDisciplina(rs.getString("nomeDisciplina"));
			dto.getProfessorDto().setChavePessoa(new Integer(rs.getInt("chavePessoa")));
			dto.getProfessorDto().setNomePessoa(rs.getString("nomePessoa"));
			dto.getProfessorDto().setApelido(rs.getString("apelido"));
			col.add(dto);
		}
		
		return col;
	}
	public Collection buscarAlunosDaTurma(String codigoTurma, Integer codigoCurso,Integer idDisciplina,Integer ano,String semestre) throws SQLException{
		
		PreparedStatement ps = getConnection().prepareStatement(SQL_LISTA_ALUNOS_DA_TURMA);
		ps.setInt(1,codigoCurso.intValue());
		ps.setInt(2,idDisciplina.intValue());
		ps.setInt(3,ano.intValue());
		ps.setString(4,semestre);
		ps.setString(5,codigoTurma);
		ResultSet rs = ps.executeQuery();
		AlunoDaTurmaDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){

			dto = new AlunoDaTurmaDTO();
			dto.setCodigoTurma(rs.getString("codigoTurma"));
			dto.getCursoDTO().setCodigoCurso(new Integer(rs.getInt("codigoCurso")));
			dto.getDisciplinaDTO().setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
			dto.getAlunoDTO().setChavePessoa(new Integer(rs.getInt("chavePessoaAluno")));
			dto.getAlunoDTO().setNomePessoa(rs.getString("nomePessoa"));
			dto.getAlunoDTO().setEmail(rs.getString("email"));
			dto.getAlunoDTO().setMatricula(rs.getString("matricula"));
			col.add(dto);
		}
		return col;
	}
	
	public ProfessorDTO buscarProfessorDaTurma(String codigoTurma, Integer codigoCurso,Integer idDisciplina,Integer ano,String semestre) throws SQLException{
		
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCA_PROFESSOR_DA_TURMA);
		ps.setInt(1,codigoCurso.intValue());
		ps.setInt(2,idDisciplina.intValue());
		ps.setInt(3,ano.intValue());
		ps.setString(4,semestre);
		ps.setString(5,codigoTurma);
		ResultSet rs = ps.executeQuery();
		ProfessorDTO dto = new ProfessorDTO();
		if(rs != null){
			rs.next();
			dto.setChavePessoa(new Integer(rs.getInt("chavePessoaProfessor")));
			dto.setNomePessoa((rs.getString("nomePessoa")));
			dto.setEmail(rs.getString("email"));
			dto.setMaiorTitulo(rs.getString("maiorTitulo"));
		}
		return dto;
	}
	public Collection buscaTurmasDoAluno(Integer chavePessoa, int anoSystem, int semestreSystem) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_LISTA_TURMAS_DO_ALUNO);
		ps.setInt(1,chavePessoa.intValue());
		ps.setInt(2,anoSystem);
		ps.setInt(3,semestreSystem);
		System.out.println(ps.toString());
		ResultSet rs = ps.executeQuery();
		AlunoDaTurmaDTO turma;
		Collection col = new ArrayList();
		while(rs.next()){
			turma = new AlunoDaTurmaDTO();
			turma.getAlunoDTO().setChavePessoa(new Integer(rs.getInt("chavePessoaAluno")));
			turma.getCursoDTO().setCodigoCurso(new Integer(rs.getInt("codigoCurso")));
			turma.setCodigoTurma(rs.getString("codigoTurma"));		
			turma.getDisciplinaDTO().setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
			
			col.add(turma);
		}
		rs.close();
		ps.close();
		return col;
	}
	public Collection buscarListasFeitasPeloAluno(Integer chavePessoa, Integer idDisciplina, Integer codigoCurso, String codigoTurma, int anoSystem, int semestreSystem) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_LISTAR_QUESTOES_FEITAS_PELO_ALUNO);
		System.out.println("Executando no STIAcompanhamentoDAO o sql para busca das listas: "+SQL_LISTAR_QUESTOES_FEITAS_PELO_ALUNO);
		ps.setInt(1,chavePessoa.intValue());
		ps.setInt(2,codigoCurso.intValue());
		ps.setInt(3,idDisciplina.intValue());
		ps.setString(4,codigoTurma);
		ps.setInt(5,anoSystem);
		ps.setString(6,new Integer(semestreSystem).toString());
		ResultSet rs = ps.executeQuery();
		ListaDTO lista; 
		Collection col = new ArrayList();
		while(rs.next()){
			lista = new ListaDTO();
			lista.setIdLista(new Integer(rs.getInt("idLista")));
			lista.getAluno().setChavePessoa(new Integer(rs.getInt("chavePessoa")));
			lista.setTituloLista(rs.getString("tituloLista"));
			lista.getCategoriaDTO().setCategoria(rs.getString("categoria"));
			lista.setDtLimiteEntrega(rs.getDate("dtLimiteEntrega"));
			
			col.add(lista);
		}
		
		return col;
	}
	private void putDisciplinaDTO(ResultSet rs, DisciplinaDTO dto) throws SQLException{
			dto.setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
			dto.setCargaHoraria(new Integer(rs.getInt("cargaHoraria")));
			dto.setNomeDisciplina(rs.getString("nomeDisciplina"));
			dto.setObjetivo(rs.getString("objetivo"));
	}


	public Collection listaDisciplinasMonitoradasPeloMonitor(Integer chavePessoa, int ano, int semestre) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_LISTA_CURSO_DISCIPLINAS_MONITORADAS_PELO_MONITOR);
		ps.setInt(1,chavePessoa.intValue());
		ps.setInt(2,ano);
		ps.setInt(3,semestre);
		ResultSet rs = ps.executeQuery();
		TurmaDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new TurmaDTO();
			dto.getDiciplinaDTO().setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
			dto.getDiciplinaDTO().setNomeDisciplina(rs.getString("nomeDisciplina"));
			dto.getCursoDTO().setCodigoCurso(new Integer(rs.getInt("codigoCurso")));
			dto.getCursoDTO().setNomeCurso(rs.getString("nomeCurso"));
			col.add(dto);
		}
		
		return col;
	}


	public AlunoDaTurmaDTO buscarAlunoDaTurma(String codigoTurma, Integer codigoCurso, Integer idDisciplina, int anoSystem, int semestreSystem, Integer chavePessoa) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCA_ALUNO_DA_TURMA);
		ps.setInt(1,codigoCurso.intValue());
		ps.setInt(2,idDisciplina.intValue());
		ps.setInt(3,anoSystem);
		ps.setString(4,new Integer(semestreSystem).toString());
		ps.setString(5,codigoTurma);
		ps.setInt(6,chavePessoa.intValue());
		ResultSet rs = ps.executeQuery();
		AlunoDaTurmaDTO dto = null;
		if(rs.next()){
			dto = new AlunoDaTurmaDTO();
			dto.setCodigoTurma(rs.getString("codigoTurma"));
			dto.getCursoDTO().setCodigoCurso(new Integer(rs.getInt("codigoCurso")));
			dto.getDisciplinaDTO().setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
			dto.getAlunoDTO().setChavePessoa(new Integer(rs.getInt("chavePessoaAluno")));
			dto.getAlunoDTO().setNomePessoa(rs.getString("nomePessoa"));
			dto.getAlunoDTO().setEmail(rs.getString("email"));
			dto.getAlunoDTO().setMatricula(rs.getString("matricula"));
		}
		return dto;
	}


	public Integer contaFrequenciaDoAlunoNaMonitoriaPorConteudo(Integer chavePessoa, Integer idDisciplina, Integer idConteudo, String dataInicio, String dataFim) throws SQLException {
		Integer frequencia = null;
		String SQL_CONTA_MONITORIA_POR_CONTEUDO = "SELECT count(a.idconteudo) as frequencia FROM pmAtendimento a, maiorConteudo c WHERE a.idConteudo = c.idConteudo and a.chavePessoaAluno = "+chavePessoa+" and a.idDisciplina = "+idDisciplina+" and a.idConteudo = "+idConteudo+" and a.dtAtendimento > '"+dataInicio+"' and dtAtendimento < '"+dataFim+"' ORDER BY a.idAtendimento, a.chavePessoaAluno;";
		
		System.out.println("Executando STIAcompanhamentoDAO select de frequencia: "+SQL_CONTA_MONITORIA_POR_CONTEUDO);
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_CONTA_MONITORIA_POR_CONTEUDO);
		if(rs.next()){
			frequencia = new Integer(rs.getInt("frequencia"));
		}
		return frequencia;
	}


	public Collection buscaAlunosDaDisciplinaSemAcompanhamento(Integer idDisciplina, int ano, int semestre) throws SQLException {
		//String SQL_LISTA_ALUNO_SEM_ACOMAPNHAMENTO = "SELECT A.chavePessoa, A.matricula, P.nomePessoa, P.dtNascer, P.cpf, P.sexo, P.email, P.apelido, P.webPessoal,A.situacao,A.dtRegistro,A.codigoCurso,A.matricula FROM maiorAluno A, maiorPessoa P, maiorTurma_Aluno T WHERE A.chavePessoa = P.chavePessoa AND A.situacao = 'A' AND A.chavePessoa = T.chavePessoaAluno AND T.idDisciplina = "+idDisciplina+" AND T.ano = '"+ano+"' AND T.semestre = '"+semestre+"' AND A.chavePessoa NOT IN(SELECT S.chavePessoaAluno FROM stiAcompanhamento S)";
		String SQL_LISTA_ALUNO_SEM_ACOMAPNHAMENTO = "SELECT A.chavePessoa, A.matricula, P.nomePessoa, P.dtNascer, P.cpf, P.sexo, P.email, P.apelido, P.webPessoal,A.situacao,A.dtRegistro,A.codigoCurso,A.matricula FROM maiorAluno A, maiorPessoa P, maiorTurma_Aluno T WHERE A.chavePessoa = P.chavePessoa AND A.situacao = 'A' AND A.chavePessoa = T.chavePessoaAluno AND T.idDisciplina = "+idDisciplina+" AND T.ano = '"+ano+"' AND T.semestre = '"+semestre+"' AND A.chavePessoa NOT IN(SELECT S.chavePessoaAluno FROM stiAcompanhamento S where S.ano = '"+ano+"' AND S.semestre = '"+semestre+"' AND S.idDisciplina = "+idDisciplina+") order by P.nomePessoa";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_LISTA_ALUNO_SEM_ACOMAPNHAMENTO);
		AlunoDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new AlunoDTO();
			putDto(rs,dto);
			col.add(dto);
		}
		return col;
	}
	private void putDto(ResultSet rs, AlunoDTO dto) throws SQLException{
		dto.setChavePessoa(new Integer(rs.getInt("chavePessoa")));
		dto.setNomePessoa(rs.getString("nomePessoa"));
		dto.setDtNascer(rs.getDate("dtNascer"));
		dto.setCpf(rs.getString("cpf"));
		dto.setApelido(rs.getString("apelido"));
		dto.setSexo(rs.getString("sexo"));
		dto.setSituacao(rs.getString("situacao"));//pegando situacao de aluno nao de pessoa
		dto.setWebPessoal(rs.getString("webPessoal"));
		dto.setEmail(rs.getString("email"));
		dto.setDtRegistro(rs.getDate("dtRegistro"));
		dto.setCodigoCurso(new Integer(rs.getInt("codigoCurso")));
		dto.setMatricula(rs.getString("matricula"));
	}
	public void cadastrarAcompanhamento(AcompanhamentoDTOSTI dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_INSERT_ACOMPANHAMENTO);
		ps.setInt(1,dto.getIdAcompanhamento().intValue());
		ps.setInt(2,dto.getDisciplina().getIdDisciplina().intValue());
		ps.setInt(3,dto.getAno().intValue());
		ps.setString(4,dto.getSemestre().toString());
		ps.setInt(5,dto.getAluno().getChavePessoa().intValue());
		ps.executeUpdate();
		ps.close();
	}
	public AcompanhamentoDTOSTI buscarAcompanhamentoSTI(Integer idDisciplina, Integer ano, String semestre, Integer chaveAluno) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAR_ACOMPANHAMENTO);
		ps.setInt(1,idDisciplina.intValue());
		ps.setInt(2,ano.intValue());
		ps.setString(3,semestre);
		ps.setInt(4,chaveAluno.intValue());
		System.out.println("Buscando acompanhamento : "+ ps.toString());
		ResultSet rs = ps.executeQuery();
		AcompanhamentoDTOSTI dto = new AcompanhamentoDTOSTI();
		if(rs.next()){
			DisciplinaDTO disciplina = new DisciplinaDTO();
			AlunoDTO aluno = new AlunoDTO();
			disciplina.setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
			aluno.setChavePessoa(new Integer(rs.getInt("chavePessoaAluno")));
			
			dto.setAno(new Integer(rs.getInt("ano")));
			dto.setSemestre(new Integer(rs.getString("semestre")));
			dto.setDisciplina(disciplina);
			dto.setAluno(aluno);
			dto.setIdAcompanhamento(new Integer(rs.getInt("idAcompanhamento")));
		}else{
			System.out.println("No existe acompanhamento ainda");
		}
		rs.close();
		ps.close();
		return dto;
	}
}