package sti.dao.acompanhamento.conteudo;

import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

import sti.dto.acompanhamento.AcompanhamentoDTO;
import dao.DAOBase;
import dto.ConteudoDTO;
public class AcompanhamentoQuestoesDAO extends DAOBase{
	
	public Collection buscarConteudosDasQuestoesFeitasPeloAluno(Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre, String dataFimSemestre) throws SQLException{
		String SQL_CONTEUDOS_DAS_QUESTOES_FEITAS_PELO_ALUNO = 
			"SELECT distinct q.idConteudo,mc.descricao FROM bdqQuestao q, bdqAluno_RespostaAvulsa r,maiorConteudo mc WHERE q.idquestao = r.idquestao and r.chavePessoa = "+chavePessoa+" and q.idConteudo = mc.idConteudo and q.idDisciplina = mc.idDisciplina and q.idDisciplina = "+idDisciplina+" and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"'  ORDER BY mc.ordem;";
			
			return executaQueryConteudo(SQL_CONTEUDOS_DAS_QUESTOES_FEITAS_PELO_ALUNO);
	}
	public Collection buscarQuestoesAvulsasVouF(Integer chavePessoa, Integer idDisciplina, String dataInicioSemestre,String dataFimSemestre,boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_AVULSAS_CERTAS_OU_ERRADAS_VOUF 
		= "SELECT q.idquestao, q.iddisciplina, q.idconteudo,q.tipoquestao, q.dificuldade, q.categoria, r.chavepessoa ALUNO,r.solucao, r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaAvulsa r, bdqVouF v, maiorConteudo mc WHERE q.idquestao = r.idquestao and r.idquestao = v.idquestao and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and q.idConteudo = mc.idConteudo and q.idDisciplina = mc.idDisciplina and r.solucao "+erradasOuErradas(certaOuErrada)+" v.resposta and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"'  ORDER BY r.chavepessoa;";
		return executaQueryDasAvulsas(SQL_BUSCA_QUESTOES_AVULSAS_CERTAS_OU_ERRADAS_VOUF);
	}
	
	public Collection buscarQuestoesAvulsasEscolhas(Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_AVULSAS_CERTAS_OU_ERRADAS_ECOLHAS
		="SELECT q.idquestao, q.iddisciplina, q.idconteudo,q.tipoquestao, q.dificuldade, q.categoria, r.chavepessoa ALUNO,r.solucao, r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaAvulsa r, bdqEscolhas e, maiorConteudo mc WHERE q.idquestao = r.idquestao and r.idquestao = e.idquestao and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" e.resposta and q.idConteudo = mc.idConteudo and q.idDisciplina = mc.idDisciplina and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"'  ORDER BY r.chavepessoa;";
		return executaQueryDasAvulsas(SQL_BUSCA_QUESTOES_AVULSAS_CERTAS_OU_ERRADAS_ECOLHAS);
	}
	public Collection buscarQuestoesAvulsasMultipla(Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_AVULSAS_CERTAS_OU_ERRADAS_MULTIPLA
		="SELECT q.idquestao, q.iddisciplina, q.idconteudo,q.tipoquestao, q.dificuldade, q.categoria, r.chavepessoa ALUNO,r.solucao, r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaAvulsa r, bdqMultipla m, maiorConteudo mc WHERE q.idquestao = r.idquestao and r.idquestao = m.idquestao and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and r.solucao "+erradasOuErradas(certaOuErrada)+" m.resposta and q.idConteudo = mc.idConteudo and q.idDisciplina = mc.idDisciplina and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"'  ORDER BY r.chavepessoa;";
		return executaQueryDasAvulsas(SQL_BUSCA_QUESTOES_AVULSAS_CERTAS_OU_ERRADAS_MULTIPLA);
	}
	public Collection buscarQuestoesAvulsasLacunas(Integer chavePessoa, Integer idDisciplina, String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_AVULSAS_CERTAS_OU_ERRADAS_LACUNAS
		="SELECT q.idquestao, r.idquestao, l.idquestao, a.idquestao,q.iddisciplina, q.idconteudo, q.tipoquestao, q.dificuldade, q.categoria,r.chavepessoa ALUNO, a.chavepessoa ALUNOS,r.solucao, r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaAvulsa r, bdqLacuna l, bdqRespostaAvulsa_Aberta a,maiorConteudo mc WHERE q.idquestao = r.idquestao and r.idquestao = l.idquestao and l.idquestao = a.idquestao and r.chavepessoa = a.chavepessoa and r.dtsolucao = a.dtsolucao and r.horariosolucao = a.horariosolucao and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and a.correcao "+erradasOuErradas(certaOuErrada)+" 'C' and q.idConteudo = mc.idConteudo and q.idDisciplina = mc.idDisciplina and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"'  ORDER BY r.chavepessoa;";
		return executaQueryDasAvulsas(SQL_BUSCA_QUESTOES_AVULSAS_CERTAS_OU_ERRADAS_LACUNAS);
	}
	
	public Collection buscarQuestoesAvulsasAbertas(Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre,String dataFimSemestre, boolean certaOuErrada) throws SQLException{
		String SQL_BUSCA_QUESTOES_AVULSAS_CERTAS_OU_ERRADAS_ABERTAS
		="SELECT q.idquestao, r.idquestao, d.idquestao, a.idquestao,q.iddisciplina, q.idconteudo, q.tipoquestao, q.dificuldade, q.categoria,r.chavepessoa ALUNO, a.chavepessoa ALUNOS,r.solucao, r.dtsolucao FROM bdqQuestao q, bdqAluno_RespostaAvulsa r, bdqAberta d, bdqRespostaAvulsa_Aberta a,maiorConteudo mc WHERE q.idquestao = r.idquestao and r.idquestao = d.idquestao and d.idquestao = a.idquestao and r.chavepessoa = a.chavepessoa and r.dtsolucao = a.dtsolucao and r.horariosolucao and a.horariosolucao and q.iddisciplina = "+idDisciplina+" and r.chavepessoa = "+chavePessoa+" and a.correcao "+erradasOuErradas(certaOuErrada)+" 'C' and q.idConteudo = mc.idConteudo and q.idDisciplina = mc.idDisciplina and r.dtSolucao >= '"+dataInicioSemestre+"' and r.dtSolucao <= '"+dataFimSemestre+"'  ORDER BY r.chavepessoa;";
		return executaQueryDasAvulsas(SQL_BUSCA_QUESTOES_AVULSAS_CERTAS_OU_ERRADAS_ABERTAS);
	}
	private Collection executaQueryDasAvulsas(String sql) throws SQLException{
		System.out.println("Executando o seguinte SQL na DAO das Avulsas: ----- "+sql);
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(sql);
		AcompanhamentoDTO dto;
		Collection col = new ArrayList();
		
		while(rs.next()){
			dto = new AcompanhamentoDTO();
			putDTO(rs,dto);
			col.add(dto);
		}
		rs.close();
		stm.close();
		return col;
	}
	
	private Collection executaQueryConteudo(String sql) throws SQLException {
		System.out.println("Executando na DAO avulsas Conteudo: "+sql);
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(sql);
		ConteudoDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new ConteudoDTO();
			dto.setIdConteudo(new Integer(rs.getInt("idConteudo")));
			dto.setDescricao(rs.getString("descricao"));
			col.add(dto);
		}
		rs.close();
		stm.close();
		return col;

	}
	private void putDTO(ResultSet rs, AcompanhamentoDTO dto) throws SQLException{
		dto.getQuestaoDTO().setIdQuestao(new Integer(rs.getInt("idQuestao")));
		dto.getQuestaoDTO().setIdDisciplina(new Integer(rs.getInt("idDisciplina")));
		dto.getQuestaoDTO().setIdConteudo(new Integer(rs.getInt("idConteudo")));
		dto.getQuestaoDTO().setDificuldade(rs.getString("dificuldade"));
		dto.getQuestaoDTO().setCategoria(rs.getString("categoria"));
		dto.setDtSolucao(rs.getDate("dtSolucao"));
	}
	
	private String erradasOuErradas(boolean certaOuErrada){
		String sinal;
		if(certaOuErrada)
			sinal = "="; //pegara as questoes certas
		else
			sinal = "<>"; //pegara as questoes erradas
		return sinal;
	}
}
