package sti.dao.desempenho.tipo;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;

import sti.dto.desempenho.tipo.TipoDesempenhoDTO;
import dao.DAOBase;

public class STITipoDesempenhoDAO extends DAOBase{
	
	private static final String SQL_INSERRE_TIPODESEMPENHO = "INSERT INTO stiTipoDesempenho VALUES (?,?,?);";
	private static final String SQL_BUSCAULTIMOINSERIDO = "SELECT MAX(idTipoDesempenho) as idTipoDesempenho FROM stiTipoDesempenho";
	private static final String SQL_BUSCA_TIPO_DESEMPENHO_POR_ID = "SELECT * FROM stiTipoDesempenho WHERE idTipoDesempenho = ?";
	private static final String SQL_EXCLUI_TIPODESEMPENHO ="DELETE FROM stiTipoDesempenho where idTipoDesempenho = ?;";
	private static String SQL_ALTERAR_TIPO_DESEMPENHO = "UPDATE stiTipoDesempenho SET nomeTipoDesempenho = ?, descricaoTipoDesempenho = ? WHERE (idTipoDesempenho = ?);";
	
	public void cadastrarTipoDesempenho(TipoDesempenhoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_INSERRE_TIPODESEMPENHO);
		ps.setInt(1,dto.getIdTipoDesempenho().intValue());
		ps.setString(2,dto.getNomeTipoDesempenho());
		ps.setString(3,dto.getDescricaoTipoDesempenho());
		ps.executeUpdate();
		ps.close();
	}
	public TipoDesempenhoDTO getUltimoInserido() throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAULTIMOINSERIDO);
		ResultSet rs = ps.executeQuery();
		TipoDesempenhoDTO dto = new TipoDesempenhoDTO();
		if(rs != null && rs.next()){
			dto.setIdTipoDesempenho(new Integer(rs.getInt("idTipoDesempenho")));
			ps.close();
			rs.close();
			return buscarTipoDesempenho(dto.getIdTipoDesempenho());
		}
		ps.close();
		rs.close();
		return dto;
	}
	public TipoDesempenhoDTO buscarTipoDesempenho(Integer idTipoDesempenho) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCA_TIPO_DESEMPENHO_POR_ID);
		ps.setInt(1,idTipoDesempenho.intValue());
		ResultSet rs = ps.executeQuery();
		TipoDesempenhoDTO dto = new TipoDesempenhoDTO();
		if(rs != null && rs.next()){
			putDTO(rs,dto);
		}
		ps.close();
		rs.close();
		
		return dto;
	}	
	public Collection buscarTipoDesempenhoPorDescricao(String descricaoTipoDesempenho) throws SQLException {
		String SQL_BUSCA_TIPO_DESEMPENHO_POR_DESCRICAO = "SELECT * FROM stiTipoDesempenho s where descricaoTipoDesempenho like '%"+descricaoTipoDesempenho+"%';";
		
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCA_TIPO_DESEMPENHO_POR_DESCRICAO);
		TipoDesempenhoDTO dto = new TipoDesempenhoDTO();
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new TipoDesempenhoDTO();
			putDTO(rs,dto);
			col.add(dto);
		}
		stm.close();
		rs.close();
		
		return col;
	}
	public Collection buscarTipoDesempenhoPorNome(String nomeTipoDesempenho) throws SQLException {
		String SQL_BUSCA_TIPO_DESEMPENHO_POR_NOME = "SELECT * FROM stiTipoDesempenho s where nomeTipoDesempenho like '%"+nomeTipoDesempenho+"%';";
		
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCA_TIPO_DESEMPENHO_POR_NOME);
		TipoDesempenhoDTO dto = new TipoDesempenhoDTO();
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new TipoDesempenhoDTO();
			putDTO(rs,dto);
			col.add(dto);
		}
		stm.close();
		rs.close();
		
		return col;
	}
	public Collection buscarTipoDesempenhoPorNomeEDescricao(String nomeTipoDesempenho, String descricaoTipoDesempenho) throws SQLException {
		String SQL_BUSCA_TIPO_DESEMPENHO_POR_NOME_E_DESCRICAO = "SELECT * FROM stiTipoDesempenho s WHERE nomeTipoDesempenho LIKE '%"+nomeTipoDesempenho+"%' AND descricaoTipoDesempenho LIKE '%"+descricaoTipoDesempenho+"%';";
		
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCA_TIPO_DESEMPENHO_POR_NOME_E_DESCRICAO);
		TipoDesempenhoDTO dto = new TipoDesempenhoDTO();
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new TipoDesempenhoDTO();
			putDTO(rs,dto);
			col.add(dto);
		}
		stm.close();
		rs.close();
		
		return col;
	}
	public Collection buscarTodosTiposDesempenho() throws SQLException {
		String SQL_BUSCA_TODOS = "SELECT * FROM stiTipoDesempenho;";
		
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCA_TODOS);
		TipoDesempenhoDTO dto = new TipoDesempenhoDTO();
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new TipoDesempenhoDTO();
			putDTO(rs,dto);
			col.add(dto);
		}
		stm.close();
		rs.close();
		
		return col;
	}
	private void putDTO(ResultSet rs, TipoDesempenhoDTO dto) throws SQLException {
		dto.setIdTipoDesempenho(new Integer(rs.getInt("idTipoDesempenho")));
		dto.setNomeTipoDesempenho(rs.getString("nomeTipoDesempenho"));
		dto.setDescricaoTipoDesempenho(rs.getString("descricaoTipoDesempenho"));
	}
	public void excluirTipoDesempenho(Integer idTipoDesempenho) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_EXCLUI_TIPODESEMPENHO);
		ps.setInt(1, idTipoDesempenho.intValue());
		ps.executeUpdate();
		ps.close();
	}
	public void alterarTipoDesempenho(TipoDesempenhoDTO dto) throws SQLException {
		
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERAR_TIPO_DESEMPENHO);
		ps.setString(1,dto.getNomeTipoDesempenho());
		ps.setString(2,dto.getDescricaoTipoDesempenho());
		ps.setInt(3,dto.getIdTipoDesempenho().intValue());
		ps.executeUpdate();
		ps.close();
	}






}
