package sti.dao.orientacao;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.Collection;
import java.util.Iterator;

import sti.dto.orientacao.OrientacaoDTO;
import sti.dto.sugestoes.SugestaoDTO;
import dao.DAOBase;

public class STIOrientacaoDAO extends DAOBase{

	private String SQL_INSERT_ORIENTACAO = "INSERT INTO stiOrientacao values(?,?,?,?,?,?,?)";
	public Integer getQuantidadeDeAtendimento(Integer idDisciplina,Integer chaveAluno,Integer idConteudo ,String dataInicial, String dataFinal) throws SQLException{
		String SQL_BUSCA_ATENDIMENTOS_DO_ALUNO = "select count(idAtendimento) as qtd from pmAtendimento where chavePessoaALuno = "+chaveAluno+" and idDisciplina = "+idDisciplina+" and dtAtendimento > '"+dataInicial+"' and dtAtendimento < '"+dataFinal+"' and idConteudo = "+idConteudo+";";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCA_ATENDIMENTOS_DO_ALUNO);
		if(rs.next())
			return new Integer(rs.getInt("qtd"));
		return null;
	}
	public Integer getQuantidadeDeQuestoesAvulsas(Integer idDisciplina,Integer chaveAluno,Integer idConteudo ,String dataInicial, String dataFinal) throws SQLException{
		String SQL_BUSCA_QTD_QUESTOES_AVULSAS_DO_ALUNO = "SELECT count(bdq.idQuestao) as qtd FROM bdqAluno_RespostaAvulsa bdqra, bdqQuestao bdq where bdq.idQuestao = bdqra.idQuestao and bdq.idDisciplina = "+idDisciplina+" and bdq.idConteudo = "+idConteudo+" and bdqra.chavePessoa = "+chaveAluno+" and bdqra.dtSolucao > '"+dataInicial+"' and bdqra.dtSolucao < '"+dataFinal+"';";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCA_QTD_QUESTOES_AVULSAS_DO_ALUNO);
		if(rs.next())
			return new Integer(rs.getInt("qtd"));
		return null;
	}
	public Integer getQuantidadeDeQuestoesListas(Integer idDisciplina,Integer chaveAluno,Integer idConteudo ,String dataInicial, String dataFinal) throws SQLException{
		String SQL_BUSCA_QTD_QUESTOES_LISTAS_DO_ALUNO = 
			"SELECT count(rl.idQuestao) as qtd FROM bdqAluno_RespostaLista rl, bdqQuestao b where b.idQuestao = rl.idQuestao and b.idConteudo = "+idConteudo+" and b.idDisciplina = "+idDisciplina+" and rl.chavePessoa = "+chaveAluno+" and rl.dtSolucao > '"+dataInicial+"' and rl.dtSolucao < '"+dataFinal+"';";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCA_QTD_QUESTOES_LISTAS_DO_ALUNO);
		if(rs.next())
			return new Integer(rs.getInt("qtd"));
		return null;
	}
	public Integer getQuantidadeDeQuestoesFeitasPeloAluno(Integer idDisciplina,Integer chaveAluno,Integer idConteudo ,String dataInicial, String dataFinal) throws SQLException{
		return new Integer(getQuantidadeDeQuestoesAvulsas(idDisciplina,chaveAluno,idConteudo,dataInicial,dataFinal).intValue() + 
		getQuantidadeDeQuestoesListas(idDisciplina,chaveAluno,idConteudo,dataInicial,dataFinal).intValue());
	}
	public OrientacaoDTO getUltimaOrientacao(Integer chaveAluno, Integer idDisciplina, Integer idConteudo, Integer ano, String semestre) throws SQLException{
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(getSQLBuscaUltimaOrientacao(chaveAluno,idDisciplina,idConteudo,ano,semestre));
		System.out.println("Buscando ultima Orientacao :"+getSQLBuscaUltimaOrientacao(chaveAluno,idDisciplina,idConteudo,ano,semestre));
		OrientacaoDTO dto = null;
		if(rs.next()){
//			System.out.println("existe uma orientao");
			dto = new OrientacaoDTO(new Integer(rs.getInt("idOrientacao")),new Integer(rs.getInt("idAcompanhamento")),new Integer(rs.getInt("idConteudo")));
			dto.setHoraOrientacao(rs.getTime("horaOrientacao"));
			dto.setDtHorientacao(rs.getDate("dtOrientacao"));
			dto.setSituacao(rs.getString("situacao"));
			dto.setRelativo(rs.getDouble("relativo"));
		}
		return dto;
	}
	public OrientacaoDTO getOrientacao(Integer idOrientacao) throws SQLException{
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery("select * from stiOrientacao where idOrientacao = "+idOrientacao);
		OrientacaoDTO dto = null;
		if(rs.next()){
			dto = new OrientacaoDTO(new Integer(rs.getInt("idOrientacao")),new Integer(rs.getInt("idAcompanhamento")),new Integer(rs.getInt("idConteudo")));
			dto.setHoraOrientacao(rs.getTime("horaOrientacao"));
			dto.setDtHorientacao(rs.getDate("dtOrientacao"));
			dto.setSituacao(rs.getString("situacao"));
			dto.setRelativo(rs.getDouble("relativo"));
		}
		return dto;
	}
	private String getSQLBuscaUltimaOrientacao(Integer chaveAluno, Integer idDisciplina, Integer idConteudo, Integer ano, String semestre){
		StringBuffer sb = new StringBuffer();
		sb.append("SELECT  o.idOrientacao,o.idAcompanhamento, o.idConteudo, o.dtOrientacao,o.horaOrientacao,o.situacao,o.relativo ");
		sb.append(" FROM stiOrientacao o, stiAcompanhamento a ");
		sb.append(" WHERE o.horaOrientacao = (SELECT max(o.horaOrientacao) FROM stiOrientacao o, stiAcompanhamento a Where o.idAcompanhamento = a.idAcompanhamento and a.idDisciplina = "+idDisciplina+" and o.idConteudo = "+idConteudo+" and a.ano = "+ano+" and a.semestre = '"+semestre+"' and a.chavePessoaAluno = "+chaveAluno+" and o.dtOrientacao = (SELECT max(o.dtOrientacao) FROM stiOrientacao o, stiAcompanhamento a Where o.idAcompanhamento = a.idAcompanhamento and a.idDisciplina = "+idDisciplina+" and o.idConteudo = "+idConteudo+" and a.ano = "+ano+" and a.semestre = '"+semestre+"' and a.chavePessoaAluno = "+chaveAluno+" )) ");
		sb.append(" and o.idAcompanhamento = a.idAcompanhamento ");
		sb.append(" and a.idDisciplina = "+idDisciplina+" and o.idConteudo = "+idConteudo+" ");  
		sb.append(" and a.ano = "+ano+" and a.semestre = '"+semestre+"' ");        
		sb.append(" and a.chavePessoaAluno = "+chaveAluno+" ");         
		sb.append(" Group by o.dtOrientacao, a.idDisciplina,a.chavePessoaAluno");
		
		return sb.toString();
	}



	public void cadastrarOrientacao(OrientacaoDTO orientacao) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_INSERT_ORIENTACAO);
		ps.setInt(1,orientacao.getIdOrientacao().intValue());
		ps.setInt(2,orientacao.getAcompanhamento().getIdAcompanhamento().intValue());
		ps.setInt(3,orientacao.getConteudo().getIdConteudo().intValue());
		ps.setDate(4,orientacao.getDtHorientacao());
		ps.setTime(5,orientacao.getHoraOrientacao());
		ps.setString(6,orientacao.getSituacao());
		ps.setDouble(7,orientacao.getRelativo());
		System.out.println(ps.toString());
		ps.executeUpdate();
		ps.close();
		System.out.println("Orientacao cadastrada com sucesso...");
	}
	public void cadastrarSugestoesDaOrientacao(OrientacaoDTO orientacao, Collection sugestoes) throws SQLException {
		for (Iterator iter = sugestoes.iterator(); iter.hasNext();) {
			SugestaoDTO element = (SugestaoDTO) iter.next();
			inserirSugestaoEOrientcao(element.getIdSugestao(),orientacao.getIdOrientacao());
		}
		
	}
	private void inserirSugestaoEOrientcao(Integer idSugestao,Integer idOrientacao) throws SQLException{
		String insert = "insert into stiConselho values(?,?)";
		PreparedStatement ps = getConnection().prepareStatement(insert);
		ps.setInt(1,idOrientacao.intValue());
		ps.setInt(2,idSugestao.intValue());
		ps.executeUpdate();
		ps.close();
	}
	
}
