package sti.dao.regra;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import sti.dto.regra.RegraDTO;
import sti.dto.sugestoes.SugestaoDTO;
import sti.tutor.desempenho.Desempenho;
import sti.tutor.esforco.Esforco;
import sti.tutor.resultado.Resultado;
import dao.DAOBase;
import mina.dao.*;

public class STIRegraDAO extends DAOBase{
	
	private final String SQL_INSERT_REGRA = "INSERT INTO bcRegras values(?,?,?,?)";
	private final String SQL_DELETE_REGRA = "DELETE FROM bcRegras WHERE idRegra = ?";
	private final String SQL_INSERT_SUGESTAO_NA_REGRA = "INSERT INTO bcRegra_Sugestao values(?,?)";
	private final String SQL_BUSCA_REGRA = "SELECT * FROM bcRegras where idRegra = ?";
	private final String SQL_BUSCAR_TODAS_REGRAS = "SELECT * FROM bcRegras;";
	private final String SQL_BUSCA_SUGESTAO_DA_REGRA = "SELECT r.idRegra, s.sugestao, s.contexto, s.idSugestao from bcRegra_Sugestao rs, stiSugestao s, bcRegras r where rs.idSugestao = s.idSugestao and r.idRegra = rs.idRegra and r.idRegra = ?";
	private final String SQL_DELETA_SUSGESTOES_DA_REGRA = "DELETE FROM bcRegra_Sugestao where idRegra = ?";
	private final String SQL_UPDATE_REGRA = "UPDATE bcRegras SET esforco = ?, desempenho = ?, resultado = ?, animation_id = ? WHERE (idRegra = ?)";
	private final String SQL_BUSCAULTIMA_REGRA_INSERIDA = "SELECT MAX(idRegra) as idRegra FROM bcRegras";
	private final String SQL_BUSCA_QTD_REGRA_POR_ESFORCO_DESEMPENHO = "SELECT count(idRegra) as qtd FROM bcregras WHERE esforco = ? AND desempenho = ?";
	
		
	public void cadastrarRegra(RegraDTO dto) throws SQLException {
		System.out.println("Cadastro: "+dto);
		PreparedStatement ps = getConnection().prepareStatement(SQL_INSERT_REGRA);
		ps.setInt(1,dto.getIdRegra().intValue());
		ps.setString(2,dto.getEsforco());
		ps.setString(3,dto.getResultado());
		ps.setString(4,dto.getDesempenho());
		ps.executeUpdate();
		ps.close();
		RegraDTO temp = buscarUltimaRegraInserida();
		dto.setIdRegra(temp.getIdRegra());
		cadastraSugestoesNaRegra(dto);
	}

	public void excluirRegra(Integer idRegra) throws SQLException{
		deleteSugestoesDaRegra(idRegra); //por causa da foreign key
		PreparedStatement ps = getConnection().prepareStatement(SQL_DELETE_REGRA);
		ps.setInt(1,idRegra.intValue());
		ps.executeUpdate();
		ps.close();
	}
	public void alterarRegra(RegraDTO dto) throws SQLException{
		deleteSugestoesDaRegra(dto.getIdRegra()); //por causa da foreign key
		PreparedStatement ps = getConnection().prepareStatement(SQL_UPDATE_REGRA);
		ps.setString(1,dto.getEsforco());
		ps.setString(2,dto.getDesempenho());
		ps.setString(3,dto.getResultado());
		ps.setInt(4, dto.getAnimation().getId());
		ps.setInt(5,dto.getIdRegra().intValue());
		ps.executeUpdate();
		ps.close();
		deleteSugestoesDaRegra(dto.getIdRegra());
		cadastraSugestoesNaRegra(dto);
	}
	public Resultado buscarResultadoDaRegra(Desempenho desempenho, Esforco esforco) throws SQLException{
	    String SQL_BUSCAR_RESULTADO_DA_REGRA = "SELECT resultado, animation_id FROM bcRegras where esforco like '%"+esforco.getTermo()+"%' and desempenho like '%"+desempenho.getTermo()+"%'";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCAR_RESULTADO_DA_REGRA);
		Resultado resultado = new Resultado();
		if(rs.next()){
			resultado.setTermo(rs.getString("resultado"));
			if(rs.getInt("animation_id")!=0)
			{
				AnimationDAO dao = new AnimationDAO();
				dao.setConnection(this.getConnection());
				resultado.setAnimation(dao.get(new Integer(rs.getInt("animation_id"))));
			}
		}
	    return resultado;
	}
	public RegraDTO buscarRegra(Integer idRegra) throws SQLException{
		RegraDTO dto = new RegraDTO();;
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCA_REGRA);
		ps.setInt(1,idRegra.intValue());
		ResultSet rs = ps.executeQuery();
		if(rs.next()){
			putRegraDTO(rs,dto);
			putSugestoesNaRegra(dto);
		}
		rs.close();
		ps.close();
		return dto;
	}
	
	/**
	 * @author Pedro Camara
	 * @param regraDTO
	 * @return quantidade de tuplas que tm o mesmo esforo e desempenho passados como parmetro
	 * @throws SQLException
	 */
	public Integer buscaQtdRegraPorEsforcoDesempenho(RegraDTO regraDTO) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCA_QTD_REGRA_POR_ESFORCO_DESEMPENHO);
		ps.setString(1, regraDTO.getEsforco().toLowerCase());
		ps.setString(2, regraDTO.getDesempenho().toLowerCase());
		ResultSet rs = ps.executeQuery();
		Integer qtd = 0;
		if (rs.next())
			qtd = rs.getInt("qtd");
		rs.close();
		ps.close();
		return qtd;
	} 
	
	public Collection buscarTodasRegras() throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAR_TODAS_REGRAS);
		ResultSet rs = ps.executeQuery();
		Collection  regras = new ArrayList();
		RegraDTO dto = null;
		while(rs.next()){
			dto = new RegraDTO();
			putRegraDTO(rs,dto);
			putSugestoesNaRegra(dto);
			regras.add(dto);
		}
		rs.close();
		ps.close();
		return regras;
	}
	public Collection buscarRegrasPorSugestao(String sugestao) throws SQLException{
		String SQL_BUSCAR_REGRA_POR_SUGESTAO = "SELECT * from bcRegra_Sugestao rs, stiSugestao s, bcRegras r where rs.idSugestao = s.idSugestao and r.idRegra = rs.idRegra and s.sugestao like '%"+sugestao+"%'";
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAR_REGRA_POR_SUGESTAO);
		ResultSet rs = ps.executeQuery();
		Collection  regras = new ArrayList();
		RegraDTO dto = null;
		while(rs.next()){
			dto = new RegraDTO();
			putRegraDTO(rs,dto);
			putSugestoesNaRegra(dto);
			regras.add(dto);
		}
		rs.close();
		ps.close();
		return regras;
	}
	
	public RegraDTO buscarUltimaRegraInserida() throws SQLException{
		RegraDTO dto = new RegraDTO();
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAULTIMA_REGRA_INSERIDA);
		ResultSet rs = ps.executeQuery();
		if(rs.next()){
			Integer idRegra = new Integer(rs.getInt("idRegra"));
			dto = buscarRegra(idRegra);
		}
		rs.close();
		ps.close();
		return dto;
	}
	
	private void cadastraSugestoesNaRegra(RegraDTO dto) throws SQLException{
		for (Iterator iter = dto.getSugestoes().iterator(); iter.hasNext();) {
			SugestaoDTO element = (SugestaoDTO) iter.next();
			addSugestoesNaRegra(dto,element);
		}
	}
	private void putRegraDTO(ResultSet rs,RegraDTO dto) throws SQLException{
		dto.setIdRegra(new Integer(rs.getInt("idRegra")));
		dto.setEsforco(rs.getString("esforco"));
		dto.setDesempenho(rs.getString("desempenho"));
		dto.setResultado(rs.getString("resultado"));
		if(rs.getInt("animation_id")!=0)
		{
			AnimationDAO dao = new AnimationDAO();
			dao.setConnection(this.getConnection());
			dto.setAnimation(dao.get(new Integer(rs.getInt("animation_id"))));
		}
	}
	private void putSugestoesNaRegra(RegraDTO dto) throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCA_SUGESTAO_DA_REGRA);
		ps.setInt(1,dto.getIdRegra().intValue());
		ResultSet rs = ps.executeQuery();
		putColecaoDeSugestoesNaRegra(rs,dto);
		rs.close();
		ps.close();
	}
	private void putColecaoDeSugestoesNaRegra(ResultSet rs, RegraDTO dto) throws SQLException {
		SugestaoDTO sugestao = null;
		while(rs.next()){
			sugestao = new SugestaoDTO();
			sugestao.setIdSugestao(new Integer(rs.getInt("idSugestao")));
			sugestao.setContexto(rs.getString("contexto"));
			sugestao.setSugestao(rs.getString("sugestao"));
			dto.getSugestoes().add(sugestao);
		}
		
	}


	private void addSugestoesNaRegra(RegraDTO regra, SugestaoDTO sugestao) throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_INSERT_SUGESTAO_NA_REGRA);
		ps.setInt(1,regra.getIdRegra().intValue());
		ps.setInt(2,sugestao.getIdSugestao().intValue());
		ps.executeUpdate();
		ps.close();
	}
	private void deleteSugestoesDaRegra(Integer idRegra) throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_DELETA_SUSGESTOES_DA_REGRA);
		ps.setInt(1,idRegra.intValue());
		ps.executeUpdate();
		ps.close();
	}

	public RegraDTO buscarRegra(Desempenho desempenho, Esforco esforco) throws SQLException {

		String SQL_BUSCA_REGRA = "SELECT * FROM bcRegra_Sugestao rs, stiSugestao s, bcRegras bc where bc.desempenho = '"+desempenho.getTermo()+"' AND bc.esforco = '"+esforco.getTermo()+"' and bc.idRegra = rs.idRegra and rs.idSugestao = s.idSugestao";
		System.out.println(SQL_BUSCA_REGRA);
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCA_REGRA);
		RegraDTO regra = null;
		Integer idRegra;
		if(rs.next()){
			idRegra = new Integer(rs.getInt("idRegra"));
			regra = buscarRegra(idRegra);
			System.out.println("Id Regra: "+idRegra);
		}
		return regra;
	}
}
