package sti.dao.sugestoes;

import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Collection;



import sti.dto.sugestoes.SugestaoDTO;

import dao.DAOBase;

public class STISugestoesDAO extends DAOBase{
	
	private static final String SQL_BUSCA_SUGESTAO_POR_ID = "SELECT * FROM stiSugestao a WHERE a.idSugestao = ?";
	private static final String SQL_BUSCAULTIMOINSERIDO = "SELECT MAX(idSugestao) as idSugestao FROM stiSugestao";
	private static String SQL_CADASTRAR_SUGESTAO = "INSERT INTO stiSugestao VALUES(?,?,?)";
	private static String SQL_BUSCAR_SUGESTOES_DE_UM_SUBPROJETO = "SELECT * FROM stiSugestao a WHERE a.contexto = ?";
	private static String SQL_EXCLUI_SUGESTAO = "DELETE FROM stiSugestao where idSugestao = ?;";
	private static String SQL_ALTERAR_SUGESTAO = "UPDATE stiSugestao SET sugestao = ?, contexto = ? WHERE (idSugestao = ?);";
	
	
	public void cadastrarSugestao(SugestaoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_CADASTRAR_SUGESTAO);
		ps.setInt(1,dto.getIdSugestao().intValue());
		ps.setString(2,dto.getSugestao());
		ps.setString(3,dto.getContexto());
		ps.executeUpdate();
		ps.close();
	}
	
	public SugestaoDTO getUltimoInserido() throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAULTIMOINSERIDO);
		ResultSet rs = ps.executeQuery();
		SugestaoDTO dto = new SugestaoDTO();
		if(rs != null && rs.next()){
			dto.setIdSugestao(new Integer(rs.getInt("idSugestao")));
			ps.close();
			rs.close();
			return buscarSugestao(dto.getIdSugestao());
		}
		ps.close();
		rs.close();
		return dto;
	}
	public SugestaoDTO buscarSugestao(Integer idSugestao) throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCA_SUGESTAO_POR_ID);
		ps.setInt(1,idSugestao.intValue());
		ResultSet rs = ps.executeQuery();
		SugestaoDTO dto = new SugestaoDTO();
		if(rs != null && rs.next()){
			putDTO(rs,dto);
		}
		ps.close();
		rs.close();
		
		return dto;
	}
	public Collection buscarSugestoesContexto(String contexto) throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_BUSCAR_SUGESTOES_DE_UM_SUBPROJETO);
		ps.setString(1,contexto);
		ResultSet rs = ps.executeQuery();
		SugestaoDTO dto;
		Collection col = new ArrayList();
		while(rs.next()){
			dto = new SugestaoDTO();
			putDTO(rs,dto);
			col.add(dto);
		}
		ps.close();
		rs.close();
		
		return col;
	}
	public Collection buscarSugestoesContextoSugestao(SugestaoDTO dto) throws SQLException{
		String SQL_BUSCAR_SUGESTOES_DE_UM_SUBPROJETO_POR_SUGESTAO = "SELECT * FROM " +
				"stiSugestao a WHERE a.contexto LIKE '"+dto.getContexto()+"' AND a.sugestao LIKE '%"+dto.getSugestao()+"%'";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCAR_SUGESTOES_DE_UM_SUBPROJETO_POR_SUGESTAO);
		SugestaoDTO dtoSugestao;
		Collection col = new ArrayList();
		while(rs.next()){
			dtoSugestao = new SugestaoDTO();
			putDTO(rs,dtoSugestao);
			col.add(dtoSugestao);
		}
		stm.close();
		rs.close();
		
		return col;
	}
	public Collection buscarTodasSugestoes() throws SQLException{
		String SQL_BUSCAR_TODAS_SUGESTOES = "SELECT * FROM stiSugestao;";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCAR_TODAS_SUGESTOES);
		SugestaoDTO dtoSugestao;
		Collection col = new ArrayList();
		while(rs.next()){
			dtoSugestao = new SugestaoDTO();
			putDTO(rs,dtoSugestao);
			col.add(dtoSugestao);
		}
		stm.close();
		rs.close();
		
		return col;
	}

	public Collection buscarSugestoes(Integer idOrientacao) throws SQLException{
		String SQL_BUSCAR_SUGESTOES = "select  o.idOrientacao, s.idSugestao, s.sugestao,s.contexto from stiOrientacao o, stiSugestao s ,stiConselho c where o.idOrientacao = c.idOrientacao and s.idSugestao = c.idSugestao and o.idOrientacao = "+idOrientacao;
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCAR_SUGESTOES);
		SugestaoDTO dtoSugestao;
		Collection col = new ArrayList();
		while(rs.next()){
			dtoSugestao = new SugestaoDTO();
			putDTO(rs,dtoSugestao);
			col.add(dtoSugestao);
		}
		stm.close();
		rs.close();
		return col;
	}
	public Collection buscarSugestoes(String sugestao) throws SQLException{
		String SQL_BUSCAR_SUGESTOES = "SELECT * FROM stiSugestao s where sugestao like '%"+sugestao+"%';";
		Statement stm = getConnection().createStatement();
		ResultSet rs = stm.executeQuery(SQL_BUSCAR_SUGESTOES);
		SugestaoDTO dtoSugestao;
		Collection col = new ArrayList();
		while(rs.next()){
			dtoSugestao = new SugestaoDTO();
			putDTO(rs,dtoSugestao);
			col.add(dtoSugestao);
		}
		stm.close();
		rs.close();
		
		return col;
	}
	public void excluirSugestao(Integer idSugestao) throws SQLException{
		PreparedStatement ps = getConnection().prepareStatement(SQL_EXCLUI_SUGESTAO);
		ps.setInt(1, idSugestao.intValue());
		ps.executeUpdate();
		ps.close();
	}
	public void alterarSugestao(SugestaoDTO dto) throws SQLException {
		PreparedStatement ps = getConnection().prepareStatement(SQL_ALTERAR_SUGESTAO);
		ps.setString(1,dto.getSugestao());
		ps.setString(2,dto.getContexto());
		ps.setInt(3,dto.getIdSugestao().intValue());
		ps.executeUpdate();
		ps.close();
	}
	private void putDTO(ResultSet rs, SugestaoDTO dto) throws SQLException {
		dto.setIdSugestao(new Integer(rs.getInt("idSugestao")));
		dto.setSugestao(rs.getString("sugestao"));
		dto.setContexto(rs.getString("contexto"));
	}


}