package sti.dto.orientacao;

import java.sql.SQLException;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;

import questao.slave.UtilDate;
import sti.model.sugestoes.STISugestoesModel;
import sti.tutor.formulas.MathBusinessResultado;
import sti.tutor.formulas.MathResultado;
import sti.tutor.resultado.Resultado;
import dto.ConteudoDTO;
import dto.LoginDTO;

public class ApoioViewOrietacao {
	private ConteudoDTO conteudo;
	private Collection sugestoes;
	private Resultado resultado;
	private String dataOrientacao;
	private String horaOrientacao;
	private static double grauDisparo;
	
	public static String getGrauDisparoString() {
		NumberFormat nf = NumberFormat.getInstance();
		nf.setMaximumFractionDigits(2);
		return nf.format(grauDisparo * 10);
	}


	public static double getGrauDisparo() {
		return grauDisparo;
	}
	public static void setGrauDisparo(double grauDisparo) {
		ApoioViewOrietacao.grauDisparo = grauDisparo;
	}
	public String getDataOrientacao() {
		return dataOrientacao;
	}
	public void setDataOrientacao(String dataOrientacao) {
		this.dataOrientacao = dataOrientacao;
	}
	public String getHoraOrientacao() {
		return horaOrientacao;
	}
	public void setHoraOrientacao(String horaOrientacao) {
		this.horaOrientacao = horaOrientacao;
	}
	public Resultado getResultado() {
		return resultado;
	}
	public void setResultado(Resultado resultado) {
		this.resultado = resultado;
	}
	public ApoioViewOrietacao() {
		setConteudo(new ConteudoDTO());
		setSugestoes(new ArrayList());
		setResultado(new Resultado());
//		setDataOrientacao(UtilDate.getDataComoString(new Date()));
//		setHoraOrientacao(UtilDate.getHoraCompletaComoString(new Date()));
//		
	}
	public ApoioViewOrietacao(OrientacaoDTO orientacao, LoginDTO login, ConteudoDTO dto) throws SQLException {
		this();
		STISugestoesModel modelSugestoes = new STISugestoesModel(login);
		setSugestoes(modelSugestoes.buscarSugestoesDaOrietacao(orientacao.getIdOrientacao()));
		setConteudo(dto);
		Resultado resultado = new Resultado();
		if(orientacao.getSituacao().equalsIgnoreCase("I"))
			resultado.setTermo("INSATISFATORIO");
		else
			resultado.setTermo("SATISFATORIO");
		loadGrau(orientacao.getRelativo(),resultado);
		setResultado(resultado);
		setDataOrientacao(UtilDate.getDataComoString(orientacao.getDtHorientacao()));
		setHoraOrientacao(UtilDate.getHoraCompletaComoString(orientacao.getHoraOrientacao()));
		setGrauDisparo(-1.0);
	}
	private void loadGrau(double relativo, Resultado resultado) {
		MathBusinessResultado mbr = new MathBusinessResultado(new MathResultado());
		resultado.setGrauPertinencia(relativo);
		if(resultado != null && resultado.getTermo() != null && resultado.getTermo().equalsIgnoreCase("SATISFATORIO"))
			resultado.setGrauSatisfatorio(mbr.getGrauSatisfatorio(resultado.getGrauPertinencia()));
		else
			resultado.setGrauSatisfatorio(1.0);//caso seja insatisfatorio...
	}
	public ApoioViewOrietacao(ConteudoDTO conteudo,Collection sugestoes, Resultado resultado) {
		setConteudo(conteudo);
		setSugestoes(sugestoes);
		setResultado(resultado);
//		setDataOrientacao(UtilDate.getDataComoString(new Date()));
//		setHoraOrientacao(UtilDate.getHoraCompletaComoString(new Date()));
	}
	public ApoioViewOrietacao(ConteudoDTO conteudo,Collection sugestoes, Resultado resultado, OrientacaoDTO orientacao) {
		setConteudo(conteudo);
		setSugestoes(sugestoes);
		setResultado(resultado);
		setDataOrientacao(UtilDate.getDataComoString(orientacao.getDtHorientacao()));
		setHoraOrientacao(UtilDate.getHoraCompletaComoString(orientacao.getHoraOrientacao()));
	}
	public ConteudoDTO getConteudo() {
		return conteudo;
	}
	public void setConteudo(ConteudoDTO conteudo) {
		this.conteudo = conteudo;
	}
	public Collection getSugestoes() {
		return sugestoes;
	}
	public void setSugestoes(Collection sugestoes) {
		this.sugestoes = sugestoes;
	}
}
