package sti.dto.orientacao;

import java.sql.Date;
import java.sql.Time;

import questao.slave.UtilDate;

import dto.ConteudoDTO;

import sti.dto.acompanhamento.AcompanhamentoDTOSTI;

public class OrientacaoDTO {
	private Integer idOrientacao;
	private AcompanhamentoDTOSTI acompanhamento;
	private ConteudoDTO conteudo;
	private Date dtHorientacao;
	private Time horaOrientacao;
	private String situacao;
	private double relativo;
	public OrientacaoDTO() {
		idOrientacao = new Integer(0);
		acompanhamento = new AcompanhamentoDTOSTI();
		conteudo = new ConteudoDTO();
		dtHorientacao = UtilDate.getDateComoSqlDate(new java.util.Date());
		horaOrientacao = UtilDate.getDateComoSqlTime(new java.util.Date());
	}
	public OrientacaoDTO(Integer idOrientacao,Integer idAcompanhamento,Integer idConteudo) {
		this();
		setIdOrientacao(idOrientacao);
		getAcompanhamento().setIdAcompanhamento(idAcompanhamento);
		getConteudo().setIdConteudo(idConteudo);
	}
	public AcompanhamentoDTOSTI getAcompanhamento() {
		return acompanhamento;
	}
	public void setAcompanhamento(AcompanhamentoDTOSTI acompanhamento) {
		this.acompanhamento = acompanhamento;
	}
	public ConteudoDTO getConteudo() {
		return conteudo;
	}
	public void setConteudo(ConteudoDTO conteudo) {
		this.conteudo = conteudo;
	}
	public Date getDtHorientacao() {
		return dtHorientacao;
	}
	public void setDtHorientacao(Date dtHorientacao) {
		this.dtHorientacao = dtHorientacao;
	}
	public Time getHoraOrientacao() {
		return horaOrientacao;
	}
	public void setHoraOrientacao(Time horaOrientacao) {
		this.horaOrientacao = horaOrientacao;
	}
	public Integer getIdOrientacao() {
		return idOrientacao;
	}
	public void setIdOrientacao(Integer idOrientacao) {
		this.idOrientacao = idOrientacao;
	}
	public double getRelativo() {
		return relativo;
	}
	public void setRelativo(double relativo) {
		this.relativo = relativo;
	}
	public String getSituacao() {
		return situacao;
	}
	public void setSituacao(String situacao) {
		this.situacao = situacao;
	}

}
