package sti.dto.regra;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import sti.dto.sugestoes.SugestaoDTO;
import mina.dto.AnimationDTO;


public class RegraDTO {
	private Integer idRegra;
	private String esforco;
	private String desempenho;
	private String resultado;
	private Collection sugestoes;
	private AnimationDTO animation;
	
	public final AnimationDTO getAnimation() {
		return animation;
	}
	public final void setAnimation(AnimationDTO animation) {
		this.animation = animation;
	}
	public RegraDTO(){
		sugestoes = new ArrayList();
	}
	public Integer getIdRegra() {
		return idRegra;
	}
	public void setIdRegra(Integer idRegra) {
		this.idRegra = idRegra;
	}


	public String getResultado() {
		return resultado;
	}
	public void setResultado(String resultado) {
		this.resultado = resultado;
	}
	public Collection getSugestoes() {
		return sugestoes;
	}
	public void setSugestoes(Collection sugestoes) {
		this.sugestoes = sugestoes;
	}
	public String toString() {
		StringBuffer sb = new StringBuffer();
		sb.append("Regra id: ");
		sb.append(getIdRegra());
		sb.append("\n");
		sb.append("Esforco: ");
		sb.append(getEsforco());
		sb.append("\n");
		sb.append("Desempenho: ");
		sb.append(getDesempenho());
		sb.append("\n");
		sb.append("Resultado: ");
		sb.append(getResultado());
		sb.append("\n");
		sb.append("Sugestoes Cadastradas: ");
		for (Iterator iter = getSugestoes().iterator(); iter.hasNext();) {
			SugestaoDTO element = (SugestaoDTO) iter.next();
			sb.append("[");
				sb.append(element.getIdSugestao());
			sb.append("]");
		}
		sb.append("\n");
		return sb.toString();
	}
	public String getDesempenho() {
		return desempenho;
	}
	public void setDesempenho(String desempenho) {
		this.desempenho = desempenho;
	}
	public String getEsforco() {
		return esforco;
	}
	public void setEsforco(String esforco) {
		this.esforco = esforco;
	}

}
