package sti.model.acompanhamento;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import model.ModelBase;
import slave.Data;
import sti.dao.acompanhamento.AcompanhamentoQuestoesListasDAO;
import sti.dto.acompanhamento.AcompanhamentoDTO;
import sti.dto.acompanhamento.VisaoAcompanhametoDTO;
import sti.dto.acompanhamento.VisaoCategoriaDTO;
import dao.DAOFactory;
import dto.ConteudoDTO;
import dto.LoginDTO;

public class AcompanhamentoListasModel extends ModelBase{

	private AcompanhamentoQuestoesListasDAO dao;
	public AcompanhamentoListasModel(LoginDTO login) {
		super(login);
		dao = getDAO();
	}
	
	
	public Collection buscarConteudosDasQuestoesDasListasFeitasPeloAluno(Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre,String dataFimSemestre) throws SQLException{
		return dao.buscarConteudosDasQuestoesDasListasFeitasPeloAluno(chavePessoa,idDisciplina,dataInicioSemestre,dataFimSemestre);
	}
	public Collection buscarConteudosDasQuestoesDasListasFeitasPeloAluno(Integer idLista, Integer chavePessoa, Integer idDisciplina ,String dataInicioSemestre,String dataFimSemestre) throws SQLException{
		return dao.buscarConteudosDasQuestoesDasListasFeitasPeloAluno(idLista,chavePessoa,idDisciplina,dataInicioSemestre,dataFimSemestre);
	}
	
	public Collection buscarAcompanhamentoDasCertas(Integer chavePessoa,Integer idDisciplina, Collection conteudos) throws SQLException{
		
		
		Collection questoesVouF = buscarQuestoesListasVouFCertas(chavePessoa,idDisciplina);
		Collection questoesMultiplas = buscarQuestoesListasMultiplasCertas(chavePessoa,idDisciplina);
		Collection questoesEscolhas = buscarQuestoesListasEscolhasCertas(chavePessoa,idDisciplina);
		Collection questoesLacunas = buscarQuestoesListasLacunasCertas(chavePessoa,idDisciplina);
		Collection questoesAbertas = buscarQuestoesListasAbertasCertas(chavePessoa,idDisciplina);
		VisaoAcompanhametoDTO visao = null;
		Collection certas = new ArrayList();
		ConteudoDTO conteudo = null;
		for (Iterator iter = conteudos.iterator(); iter.hasNext();) {
			conteudo = (ConteudoDTO) iter.next();
			visao = new VisaoAcompanhametoDTO();
			slavePutConteudoNaVisao(conteudo,visao);
			certas.add(visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesVouF,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesMultiplas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesEscolhas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesLacunas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesAbertas,conteudo,visao);
		}
		System.gc();
		/*System.out.println("certas");
		for (Iterator iter = certas.iterator(); iter.hasNext();) {
			VisaoAcompanhametoDTO element = (VisaoAcompanhametoDTO) iter.next();
			System.out.println(element);
		}*/
		return certas;
	}
	
	public Collection buscarAcompanhamentoDasErradas(Integer chavePessoa,Integer idDisciplina,Collection conteudos) throws SQLException{
		
		
		Collection questoesVouF = buscarQuestoesListasVouFErradas(chavePessoa,idDisciplina);
		Collection questoesMultiplas = buscarQuestoesListasMultiplasErradas(chavePessoa,idDisciplina);
		Collection questoesEscolhas = buscarQuestoesListasEscolhasErradas(chavePessoa,idDisciplina);
		Collection questoesLacunas = buscarQuestoesListasLacunasErradas(chavePessoa,idDisciplina);
		Collection questoesAbertas = buscarQuestoesListasAbertasErradas(chavePessoa,idDisciplina);
		VisaoAcompanhametoDTO visao = null;
		Collection erradas = new ArrayList();
		ConteudoDTO conteudo = null;
		for (Iterator iter = conteudos.iterator(); iter.hasNext();) {
			conteudo = (ConteudoDTO) iter.next();
			visao = new VisaoAcompanhametoDTO();
			slavePutConteudoNaVisao(conteudo,visao);
			erradas.add(visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesVouF,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesMultiplas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesEscolhas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesLacunas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesAbertas,conteudo,visao);
			
		}
		System.out.println("********************* Fim Erradas Listas **********************");
		System.gc();
		/*System.out.println("erradas");
		for (Iterator iter = erradas.iterator(); iter.hasNext();) {
			VisaoAcompanhametoDTO element = (VisaoAcompanhametoDTO) iter.next();
			System.out.println(element);
		}*/
		
		return erradas;
	}
	//ESCOLHAS------------------------------------------------------
		//CERTAS
	public Collection buscarQuestoesListasEscolhasCertas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result = getDAO().buscarQuestoesListasEscolhas(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasEscolhasCertas(Integer idLista,Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasEscolhas(idLista,chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasEscolhasCertasPorConteudo(Integer idLista,Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasEscolhasPorConteudo(idLista,chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasEscolhasCertasPorConteudo(Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasEscolhasPorConteudo(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
		//ERRADAS
	public Collection buscarQuestoesListasEscolhasErradas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasEscolhas(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasEscolhasErradas(Integer idLista,Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasEscolhas(idLista,chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasEscolhasErradasPorConteudo(Integer idLista,Integer chavePessoa,Integer idDisciplina, Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasEscolhasPorConteudo(idLista,chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasEscolhasErradasPorConteudo(Integer chavePessoa,Integer idDisciplina, Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result = getDAO().buscarQuestoesListasEscolhasPorConteudo(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	
	//	VERDADEIRAS OU FALSAS----------------------------------------------------
		//CERTAS
	public Collection buscarQuestoesListasVouFCertas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasVouF(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasVouFCertas(Integer idLista, Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasVouF(idLista,chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasVouFCertasPorConteudo(Integer idLista, Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasVouFPorConteudo(idLista,chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasVouFCertasPorConteudo(Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasVouFPorConteudo(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
		//ERRADAS
	public Collection buscarQuestoesListasVouFErradas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasVouF(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasVouFErradas(Integer idLista, Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasVouF(idLista, chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasVouFErradasPorConteudo(Integer idLista, Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasVouFPorConteudo(idLista, chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasVouFErradasPorConteudo(Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasVouFPorConteudo( chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	// MULTIPLAS
		//CERTAS
	public Collection buscarQuestoesListasMultiplasCertas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasMultipla(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasMultiplasCertas(Integer idLista,Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasMultipla(idLista,chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasMultiplasCertasPorConteudo(Integer idLista,Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasMultiplaPorConteudo(idLista,chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasMultiplasCertasPorConteudo(Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasMultiplaPorConteudo(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
		//ERRADAS
	public Collection buscarQuestoesListasMultiplasErradas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasMultipla(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasMultiplasErradas(Integer idLista, Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasMultipla(idLista, chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasMultiplasErradasPorConteudo(Integer idLista, Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasMultiplaPorConteudo(idLista, chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasMultiplasErradasPorConteudo(Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasMultiplaPorConteudo(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	//LACUNA
		//CERTAS
	public Collection buscarQuestoesListasLacunasCertas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasLacunas(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasLacunasCertas(Integer idLista, Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasLacunas(idLista, chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasLacunasCertasPorConteudo(Integer idLista, Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasLacunasPorConteudo(idLista, chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasLacunasCertasPorConteudo(Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasLacunasPorConteudo(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
		//ERRADAS
	public Collection buscarQuestoesListasLacunasErradas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasLacunas(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasLacunasErradas(Integer idLista, Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasLacunas(idLista, chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasLacunasErradasPorConteudo(Integer idLista, Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasLacunasPorConteudo(idLista, chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasLacunasErradasPorConteudo( Integer chavePessoa,Integer idDisciplina,Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasLacunasPorConteudo(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	//ABERTAS
		//CERTAS
	public Collection buscarQuestoesListasAbertasCertas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasAbertas(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasAbertasCertas(Integer idLista,Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasAbertas(idLista,chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasAbertasCertasPorConteudo(Integer idLista,Integer chavePessoa,Integer idDisciplina, Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasAbertasPorConteudo(idLista,chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasAbertasCertasPorConteudo(Integer chavePessoa,Integer idDisciplina, Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasAbertasPorConteudo(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
		//ERRADAS
	public Collection buscarQuestoesListasAbertasErradas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasAbertas(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasAbertasErradas(Integer idLista, Integer chavePessoa,Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasAbertas(idLista, chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasAbertasErradasPorConteudo(Integer idLista,Integer chavePessoa,Integer idDisciplina, Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasAbertasPorConteudo(idLista,chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesListasAbertasErradasPorConteudo(Integer chavePessoa,Integer idDisciplina, Integer idConteudo) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarQuestoesListasAbertasPorConteudo(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	
	//-----------------------------------------------------------------------------------------------------------------------------------------------
	// esse metodo  o corao para mostrar os dados na Jsp ele que preenche o objeo que sera impresSo na jsp.
	private void putVisaoAcompanhamento(AcompanhamentoDTO element,ConteudoDTO conteudo, VisaoAcompanhametoDTO visao){
				slavePutDificuldadeNaVisao(element,visao);
	}
	private void iteratorCollectionAcompanhamentoDasQuetoes(Collection questoes,ConteudoDTO conteudo, VisaoAcompanhametoDTO visao){
		for (Iterator iter2 = questoes.iterator(); iter2.hasNext();) {
			AcompanhamentoDTO element = (AcompanhamentoDTO) iter2.next();
			if(conteudo.getIdConteudo().intValue()  == element.getQuestaoDTO().getIdConteudo().intValue()){
				putVisaoAcompanhamento(element,conteudo,visao);
			}
		}
	}
	private void slavePutConteudoNaVisao(ConteudoDTO conteudo, VisaoAcompanhametoDTO visao){
		visao.getConteudo().setIdConteudo(conteudo.getIdConteudo());
		visao.getConteudo().setDescricao(conteudo.getDescricao());
	}
	private void slavePutCategoriaNaVisao(VisaoCategoriaDTO categoria, AcompanhamentoDTO element){

		if(element.getQuestaoDTO().getCategoria().equalsIgnoreCase("R")){
			categoria.setContCategoriaRevisao(categoria.getContCategoriaRevisao()+1);
		}else if(element.getQuestaoDTO().getCategoria().equalsIgnoreCase("A")){
			categoria.setContCategoriaAvaliacao(categoria.getContCategoriaAvaliacao()+1);
		}else{
			categoria.setContCategoriaFixacao(categoria.getContCategoriaFixacao()+1);
		}
	}
	private void slavePutDificuldadeNaVisao(AcompanhamentoDTO element, VisaoAcompanhametoDTO visao){

		if(element.getQuestaoDTO().getDificuldade().equals("F")){ // se a questao for facil
			visao.getDificuldade().setContFacil(visao.getDificuldade().getContFacil()+1);//incrementa
			slavePutCategoriaNaVisao(visao.getDificuldade().getCategoriaFacil(),element);


		}else if(element.getQuestaoDTO().getDificuldade().equals("M")){ // se a questao for facil
			visao.getDificuldade().setContMedio(visao.getDificuldade().getContMedio()+1);//incrementa
			slavePutCategoriaNaVisao(visao.getDificuldade().getCategoriaMedio(),element);


		}else{
			visao.getDificuldade().setContDificil(visao.getDificuldade().getContDificil()+1);//incrementa
			slavePutCategoriaNaVisao(visao.getDificuldade().getCategoriaDificil(),element);
		}
	}
	private AcompanhamentoQuestoesListasDAO getDAO(){
		try {
			dao = (AcompanhamentoQuestoesListasDAO)DAOFactory.getInstance().getDAO("sti.dao.acompanhamento.AcompanhamentoQuestoesListasDAO",getLoginDTOUsuarioLogado());
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return dao;
	}


	public Collection buscarAcompanhamentoDasCertas(Integer idLista, Integer chavePessoa, Integer idDisciplina,Collection conteudos) throws SQLException {
		
		Collection questoesVouF = buscarQuestoesListasVouFCertas(idLista,chavePessoa,idDisciplina);
		Collection questoesMultiplas = buscarQuestoesListasMultiplasCertas(idLista,chavePessoa,idDisciplina);
		Collection questoesEscolhas = buscarQuestoesListasEscolhasCertas(idLista,chavePessoa,idDisciplina);
		Collection questoesLacunas = buscarQuestoesListasLacunasCertas(idLista,chavePessoa,idDisciplina);
		Collection questoesAbertas = buscarQuestoesListasAbertasCertas(idLista,chavePessoa,idDisciplina);
		VisaoAcompanhametoDTO visao = null;
		Collection certas = new ArrayList();
		ConteudoDTO conteudo = null;
		for (Iterator iter = conteudos.iterator(); iter.hasNext();) {
			conteudo = (ConteudoDTO) iter.next();
			visao = new VisaoAcompanhametoDTO();
			slavePutConteudoNaVisao(conteudo,visao);
			certas.add(visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesVouF,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesMultiplas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesEscolhas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesLacunas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesAbertas,conteudo,visao);
		}
		System.gc();

		return certas;
	}


	public Collection buscarAcompanhamentoDasErradas(Integer idLista, Integer chavePessoa, Integer idDisciplina, Collection conteudos) throws SQLException {
			
		Collection questoesVouF = buscarQuestoesListasVouFErradas(idLista,chavePessoa,idDisciplina);
		Collection questoesMultiplas = buscarQuestoesListasMultiplasErradas(idLista,chavePessoa,idDisciplina);
		Collection questoesEscolhas = buscarQuestoesListasEscolhasErradas(idLista,chavePessoa,idDisciplina);
		Collection questoesLacunas = buscarQuestoesListasLacunasErradas(idLista,chavePessoa,idDisciplina);
		Collection questoesAbertas = buscarQuestoesListasAbertasErradas(idLista,chavePessoa,idDisciplina);
		VisaoAcompanhametoDTO visao = null;
		Collection erradas = new ArrayList();
		ConteudoDTO conteudo = null;
		for (Iterator iter = conteudos.iterator(); iter.hasNext();) {
			conteudo = (ConteudoDTO) iter.next();
			visao = new VisaoAcompanhametoDTO();
			slavePutConteudoNaVisao(conteudo,visao);
			erradas.add(visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesVouF,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesMultiplas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesEscolhas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesLacunas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesAbertas,conteudo,visao);
			
		}
		System.gc();

		
		return erradas;
	}



}
