package sti.model.acompanhamento;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import model.ModelBase;
import slave.Data;
import sti.dao.acompanhamento.AcompanhamentoQuestoesDAO;
import sti.dto.acompanhamento.AcompanhamentoDTO;
import sti.dto.acompanhamento.VisaoAcompanhametoDTO;
import sti.dto.acompanhamento.VisaoCategoriaDTO;
import sti.geral.DataSTI;
import dao.DAOFactory;
import dto.ConteudoDTO;
import dto.LoginDTO;
public class AcompanhamentoQuestoesModel extends ModelBase{
	private AcompanhamentoQuestoesDAO dao;
	public AcompanhamentoQuestoesModel(LoginDTO login) {
		super(login);
		
	}
	
	
	public Collection buscarConteudosDasQuestoesFeitasPeloAluno(Integer chavePessoa, Integer idDisciplina,String dataInicioSemestre, String dataFimSemestre) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result = getDAO().buscarConteudosDasQuestoesFeitasPeloAluno(chavePessoa,idDisciplina,dataInicioSemestre,dataFimSemestre);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarAcompanhamentoDasCertas(Integer chavePessoa,Integer idDisciplina,Collection conteudos) throws SQLException{
		
		
		Collection questoesVouF = buscarQuestoesAvulsasVouFCertas(chavePessoa,idDisciplina);
		Collection questoesMultiplas = buscarQuestoesAvulsasMultiplasCertas(chavePessoa,idDisciplina);
		Collection questoesEscolhas = buscarQuestoesAvulsasEscolhasCertas(chavePessoa,idDisciplina);
		Collection questoesLacunas = buscarQuestoesAvulsasLacunasCertas(chavePessoa,idDisciplina);
		Collection questoesAbertas = buscarQuestoesAvulsasAbertasCertas(chavePessoa,idDisciplina);
		VisaoAcompanhametoDTO visao = null;
		Collection certas = new ArrayList();
		ConteudoDTO conteudo = null;
		for (Iterator iter = conteudos.iterator(); iter.hasNext();) {
			conteudo = (ConteudoDTO) iter.next();
			visao = new VisaoAcompanhametoDTO();
			slavePutConteudoNaVisao(conteudo,visao);
			certas.add(visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesVouF,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesMultiplas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesEscolhas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesLacunas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesAbertas,conteudo,visao);
		}
		System.gc();
		return certas;
	}
	
	public Collection buscarAcompanhamentoDasErradas(Integer chavePessoa,Integer idDisciplina, Collection conteudos) throws SQLException{
		
		
		Collection questoesVouF = buscarQuestoesAvulsasVouFErradas(chavePessoa,idDisciplina);
		Collection questoesMultiplas = buscarQuestoesAvulsasMultiplasErradas(chavePessoa,idDisciplina);
		Collection questoesEscolhas = buscarQuestoesAvulsasEscolhasErradas(chavePessoa,idDisciplina);
		Collection questoesLacunas = buscarQuestoesAvulsasLacunasErradas(chavePessoa,idDisciplina);
		Collection questoesAbertas = buscarQuestoesAvulsasAbertasErradas(chavePessoa,idDisciplina);
		VisaoAcompanhametoDTO visao = null;
		Collection erradas = new ArrayList();
		ConteudoDTO conteudo = null;
		for (Iterator iter = conteudos.iterator(); iter.hasNext();) {
			conteudo = (ConteudoDTO) iter.next();
			visao = new VisaoAcompanhametoDTO();
			slavePutConteudoNaVisao(conteudo,visao);
			erradas.add(visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesVouF,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesMultiplas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesEscolhas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesLacunas,conteudo,visao);
			iteratorCollectionAcompanhamentoDasQuetoes(questoesAbertas,conteudo,visao);
			
		}
		System.gc();

		return erradas;
	}
//	private void debug(Collection col){
//		System.out.println("-------------------Debug--------------------------");
//		for (Iterator iter = col.iterator(); iter.hasNext();) {
//			AcompanhamentoDTO element = (AcompanhamentoDTO) iter.next();
//			System.out.println(element);
//		}
//	}
	public Collection buscarQuestoesAvulsasEscolhasCertas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasEscolhas(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasEscolhasErradas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasEscolhas(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasVouFCertas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasVouF(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasVouFErradas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasVouF(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasMultiplasCertas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasMultipla(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	
	public Collection buscarQuestoesAvulsasMultiplasErradas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasMultipla(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	

	public Collection buscarQuestoesAvulsasLacunasCertas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasLacunas(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasLacunasErradas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasLacunas(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasAbertasCertas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasAbertas(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasAbertasErradas(Integer chavePessoa,Integer idDisciplina) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasAbertas(chavePessoa,idDisciplina,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	//+++++++++++++++++++++++POR CONTEUDO+++++++++++++++++++++++++++++++++++++++
	public Collection buscarQuestoesAvulsasEscolhasCertas(Integer chavePessoa,Integer idDisciplina,Integer idConteudo ) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasEscolhas(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasEscolhasErradas(Integer chavePessoa,Integer idDisciplina,Integer idConteudo ) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasEscolhas(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasVouFCertas(Integer chavePessoa,Integer idDisciplina,Integer idConteudo ) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasVouF(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasVouFErradas(Integer chavePessoa,Integer idDisciplina,Integer idConteudo ) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasVouF(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasMultiplasCertas(Integer chavePessoa,Integer idDisciplina,Integer idConteudo ) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasMultipla(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	
	public Collection buscarQuestoesAvulsasMultiplasErradas(Integer chavePessoa,Integer idDisciplina,Integer idConteudo ) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasMultipla(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	

	public Collection buscarQuestoesAvulsasLacunasCertas(Integer chavePessoa,Integer idDisciplina,Integer idConteudo ) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasLacunas(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
		
	}
	public Collection buscarQuestoesAvulsasLacunasErradas(Integer chavePessoa,Integer idDisciplina,Integer idConteudo ) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasLacunas(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasAbertasCertas(Integer chavePessoa,Integer idDisciplina,Integer idConteudo ) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasAbertas(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),true);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarQuestoesAvulsasAbertasErradas(Integer chavePessoa,Integer idDisciplina,Integer idConteudo ) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarQuestoesAvulsasAbertas(chavePessoa,idDisciplina,idConteudo,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre(),false);
		fechaConexao(dao);
		return result;
	}	
	
	
	//++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++
	// esse metodo  o corao para mostrar os dados na Jsp ele que preenche o objeo que sera impreso na jsp.
	private void putVisaoAcompanhamento(AcompanhamentoDTO element,ConteudoDTO conteudo, VisaoAcompanhametoDTO visao){

				slavePutDificuldadeNaVisao(element,visao);
	}
	private void iteratorCollectionAcompanhamentoDasQuetoes(Collection questoes,ConteudoDTO conteudo, VisaoAcompanhametoDTO visao){
		for (Iterator iter2 = questoes.iterator(); iter2.hasNext();) {
			AcompanhamentoDTO element = (AcompanhamentoDTO) iter2.next();
			if(conteudo.getIdConteudo().intValue()  == element.getQuestaoDTO().getIdConteudo().intValue()){
				putVisaoAcompanhamento(element,conteudo,visao);
			}
		}
	}
	private void slavePutConteudoNaVisao(ConteudoDTO conteudo, VisaoAcompanhametoDTO visao){
		visao.getConteudo().setIdConteudo(conteudo.getIdConteudo());
		visao.getConteudo().setDescricao(conteudo.getDescricao());
	}
	private void slavePutCategoriaNaVisao(VisaoCategoriaDTO categoria, AcompanhamentoDTO element){

		if(element.getQuestaoDTO().getCategoria().equalsIgnoreCase("R")){
			categoria.setContCategoriaRevisao(categoria.getContCategoriaRevisao()+1);
		}else if(element.getQuestaoDTO().getCategoria().equalsIgnoreCase("A")){
			categoria.setContCategoriaAvaliacao(categoria.getContCategoriaAvaliacao()+1);
		}else{
			categoria.setContCategoriaFixacao(categoria.getContCategoriaFixacao()+1);
		}
	}
	private void slavePutDificuldadeNaVisao(AcompanhamentoDTO element, VisaoAcompanhametoDTO visao){

		if(element.getQuestaoDTO().getDificuldade().equals("F")){ // se a questao for facil
			visao.getDificuldade().setContFacil(visao.getDificuldade().getContFacil()+1);//incrementa
			slavePutCategoriaNaVisao(visao.getDificuldade().getCategoriaFacil(),element);

		}else if(element.getQuestaoDTO().getDificuldade().equals("M")){ // se a questao for facil
			visao.getDificuldade().setContMedio(visao.getDificuldade().getContMedio()+1);//incrementa
			slavePutCategoriaNaVisao(visao.getDificuldade().getCategoriaMedio(),element);

		}else{
			visao.getDificuldade().setContDificil(visao.getDificuldade().getContDificil()+1);//incrementa
			slavePutCategoriaNaVisao(visao.getDificuldade().getCategoriaDificil(),element);

		}
	}
	private AcompanhamentoQuestoesDAO getDAO(){
		try {
			dao = (AcompanhamentoQuestoesDAO)DAOFactory.getInstance().getDAO("sti.dao.acompanhamento.AcompanhamentoQuestoesDAO",getLoginDTOUsuarioLogado());
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return dao;
	}



}
