package sti.model.acompanhamento;

import java.sql.SQLException;
import java.util.Collection;
import java.util.Iterator;

import com.mysql.jdbc.exceptions.MySQLIntegrityConstraintViolationException;

import model.AlunoModel;
import model.CursoModel;
import model.DisciplinaModel;
import model.ModelBase;
import slave.Data;
import sti.dao.acompanhamento.STIAcompanhamentoDAO;
import sti.dto.acompanhamento.AcompanhamentoDTOSTI;
import sti.dto.acompanhamento.VisaoAcompanhametoDTO;
import sti.dto.turma.AlunoDaTurmaDTO;
import dao.DAOFactory;
import dto.AlunoDTO;
import dto.DisciplinaDTO;
import dto.LoginDTO;
import dto.ProfessorDTO;

public class STIAcompanhamentoModel extends ModelBase{
	private STIAcompanhamentoDAO dao;
	private LoginDTO login;
	public STIAcompanhamentoModel(LoginDTO login) {
		super(login);
		this.login = login;

		// TODO Auto-generated constructor stub
	}
	public Collection listaDisciplinasDoAluno(Integer chavePessoa){
		try {
			Collection result;
			abreConexao(getDAO(), dao);
			result = getDAO().buscaDisciplinasDoAluno(chavePessoa);
			fechaConexao(dao);
			return result;
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
	public Integer contaFrequenciaDoAlunoNaMonitoriaPorConteudo(Integer chavePessoa, Integer idDisciplina, Integer idConteudo, String dataInicio, String dataFim) throws SQLException{
		Integer result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().contaFrequenciaDoAlunoNaMonitoriaPorConteudo(chavePessoa, idDisciplina,idConteudo, dataInicio, dataFim);
		fechaConexao(dao);
		return result;
	}
	public void setFrequencia(Collection col, Integer chavePessoa, Integer idDisciplina, String dataInicio, String dataFim) throws SQLException{
		getDAO();
		for (Iterator iter = col.iterator(); iter.hasNext();) {
			VisaoAcompanhametoDTO element = (VisaoAcompanhametoDTO) iter.next();
			element.setFrequencia(dao.contaFrequenciaDoAlunoNaMonitoriaPorConteudo(chavePessoa,idDisciplina,element.getConteudo().getIdConteudo(),dataInicio,dataFim));
		}
		fechaConexao(dao);
	}
	public Collection buscarTurmasDaDisciplina(Integer idDisciplina, Integer codigoCurso, int anoSystem, int semestreSystem) throws SQLException {
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarTurmasDaDisciplina(idDisciplina,codigoCurso,anoSystem,semestreSystem);
		fechaConexao(dao);
		return result;
	}
	public Collection listaDisciplinasMonitoradasPeloMonitor(Integer chavePessoa, int ano, int semestre) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().listaDisciplinasMonitoradasPeloMonitor(chavePessoa,ano,semestre);
		fechaConexao(dao);
		return result;
	}
	public Collection listaDisciplinasMinistradasPeloProfessor(Integer chavePessoa, int ano, int semestre) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().listaDisciplinasMinistradasPeloProfessor(chavePessoa,ano,semestre);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarAlunosDaTurma(String codigoTurma, Integer codigoCurso, Integer idDisciplina, int anoSystem, String semestre) throws SQLException {
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarAlunosDaTurma(codigoTurma,codigoCurso,idDisciplina,new Integer(anoSystem),semestre);
		fechaConexao(dao);
		return result;
		
	}
	public ProfessorDTO buscarProfessorDaTurma(String codigoTurma, Integer codigoCurso, Integer idDisciplina, int anoSystem, String semestre) throws SQLException {
		ProfessorDTO result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarProfessorDaTurma(codigoTurma,codigoCurso,idDisciplina,new Integer(anoSystem),semestre);
		fechaConexao(dao);
		return result;
		
	}
	public Collection buscarListasFeitasPeloAluno(Integer chavePessoa, Integer idDisciplina, Integer codigoCurso, String codigoTurma, int anoSystem, int semestreSystem) throws SQLException {
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarListasFeitasPeloAluno(chavePessoa,idDisciplina,codigoCurso,codigoTurma,anoSystem,semestreSystem);
		fechaConexao(dao);
		return result;
	}
	public Collection listaTurmasDoAluno(Integer chavePessoa, int anoSystem, int semestreSystem) throws SQLException {
//		abreConexao(getDAO(), dao);
		System.out.println("teste 11");
		Collection col = getDAO().buscaTurmasDoAluno(chavePessoa,anoSystem,semestreSystem);
		System.out.println("teste 12");
		preencheTurmaAluno(col);
		System.out.println("teste 13");
		fechaConexao(dao);
		System.out.println("teste 14");
		return col;
	}
	public Collection buscaAlunosDaDisciplinaSemAcompanhamento(Integer idDisciplina) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscaAlunosDaDisciplinaSemAcompanhamento(idDisciplina,Data.getAnoSystem(),Data.getSemestreSystem());
		fechaConexao(dao);
		return result;
	}
	private void preencheTurmaAluno(Collection col) throws SQLException {
		AlunoModel alunoModel = new AlunoModel(login);
		DisciplinaModel disciplinaModel = new DisciplinaModel(login);
		CursoModel cursoModel = new  CursoModel(login);
		for (Iterator iter = col.iterator(); iter.hasNext();) {
			AlunoDaTurmaDTO element = (AlunoDaTurmaDTO) iter.next();
			element.setAlunoDTO(alunoModel.buscarAluno(element.getAlunoDTO().getChavePessoa()));
			element.setDisciplinaDTO(disciplinaModel.buscarDisciplina(element.getDisciplinaDTO().getIdDisciplina()));
			element.setCursoDTO(cursoModel.buscarCurso(element.getCursoDTO().getCodigoCurso()));
			element.setProfessor(buscarProfessorDaTurma(element.getCodigoTurma(),element.getCursoDTO().getCodigoCurso(),element.getDisciplinaDTO().getIdDisciplina(),Data.getAnoSystem(),new Integer(Data.getSemestreSystem()).toString()));
		}
	}
	public void gerarAcompanhamentoDosAlunos(Collection alunos,Integer idDisciplina) throws SQLException {
		for (Iterator iter = alunos.iterator(); iter.hasNext();) {
			AlunoDTO element = (AlunoDTO) iter.next();
			gerarAcompanhamentoDoAluno(element,idDisciplina); 
		}
	}
	
	public void gerarAcompanhamentoDoAluno(AlunoDTO element,Integer idDisciplina) throws SQLException {
		AcompanhamentoDTOSTI dto = new AcompanhamentoDTOSTI();
		putAcompanhamentoDTOSTI(dto,element,idDisciplina);
//		abreConexao(getDAO(), dao);
		try {
			getDAO().cadastrarAcompanhamento(dto);
			fechaConexao(dao);
		} catch (MySQLIntegrityConstraintViolationException e) {
			e.printStackTrace();
		}
		
	}
	private void putAcompanhamentoDTOSTI(AcompanhamentoDTOSTI dto, AlunoDTO element,Integer idDisciplina) {
		DisciplinaDTO disciplina = new DisciplinaDTO();
		disciplina.setIdDisciplina(idDisciplina);
		dto.setAluno(element);
		dto.setDisciplina(disciplina);
		dto.setAno(new Integer(Data.getAnoSystem()));
		dto.setSemestre(new Integer(Data.getSemestreSystem()));

	}
	private STIAcompanhamentoDAO getDAO(){
		try {
			dao = (STIAcompanhamentoDAO)DAOFactory.getInstance().getDAO("sti.dao.acompanhamento.STIAcompanhamentoDAO",getLoginDTOUsuarioLogado());
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return dao;
	}
	public AlunoDaTurmaDTO buscarALunoDaTurma(String codigoTurma, Integer codigoCurso, Integer idDisciplina, int anoSystem, int semestreSystem, Integer chavePessoa) throws SQLException {
//		abreConexao(getDAO(), dao);
		AlunoDaTurmaDTO aluno = getDAO().buscarAlunoDaTurma(codigoTurma,codigoCurso,idDisciplina,anoSystem,semestreSystem,chavePessoa);
		aluno.setCursoDTO(new CursoModel(login).buscarCurso(codigoCurso));
		aluno.setDisciplinaDTO(new DisciplinaModel(login).buscarDisciplina(idDisciplina));
		fechaConexao(dao);
		return aluno;
	}

	public AcompanhamentoDTOSTI buscarAcompanhamentoSTI(Integer idDisciplina, Integer ano, String semestre, Integer chaveAluno) throws SQLException {
		AcompanhamentoDTOSTI result;
//		abreConexao(getDAO(), dao);
		result =  getDAO().buscarAcompanhamentoSTI(idDisciplina,ano,semestre,chaveAluno);
		fechaConexao(dao);
		return result;
	}
}
