package sti.model.desempenho.tipo;

import java.sql.SQLException;
import java.util.Collection;

import model.ModelBase;
import sti.dao.desempenho.tipo.STITipoDesempenhoDAO;
import sti.dto.desempenho.tipo.TipoDesempenhoDTO;
import dao.DAOFactory;
import dto.LoginDTO;

public class STITipoDesempenhoModel extends ModelBase{
	private STITipoDesempenhoDAO dao;
	public STITipoDesempenhoModel(LoginDTO login) {
		super(login);
	
	}
	

	public void cadastrarTipoDesempenho(TipoDesempenhoDTO dto) throws SQLException {
//		abreConexao(getDAO(), dao);
		getDAO().cadastrarTipoDesempenho(dto);
		fechaConexao(dao);
	}
	public TipoDesempenhoDTO getUltimoInserido() throws SQLException {
//		abreConexao(getDAO(), dao);
		TipoDesempenhoDTO dto = getDAO().getUltimoInserido();
		fechaConexao(dao);
		return dto;
	}
	public Collection filtraBuscaTipoDescricao(TipoDesempenhoDTO dto) throws SQLException{
		
		Collection result;
		if(dto.getDescricaoTipoDesempenho().equalsIgnoreCase(""))
			if(dto.getNomeTipoDesempenho().equalsIgnoreCase(""))
				result = buscarTodosTiposDesempenho();
			else
				result =  buscarTipoDesempenhoPorNome(dto.getNomeTipoDesempenho());
		else
			if(dto.getNomeTipoDesempenho().equalsIgnoreCase(""))
				result =  buscarTipoDesempenhoPorDescricao(dto.getDescricaoTipoDesempenho());
			else
				result =  buscarTipoDesempenhoPorNomeEDescricao(dto.getNomeTipoDesempenho(),dto.getDescricaoTipoDesempenho());
		
		
		return result;
	}
	public Collection buscarTipoDesempenhoPorDescricao(String descricaoTipoDesempenho) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =  getDAO().buscarTipoDesempenhoPorDescricao(descricaoTipoDesempenho);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarTipoDesempenhoPorNome(String nomeTipoDesempenho) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =   getDAO().buscarTipoDesempenhoPorNome(nomeTipoDesempenho);
		fechaConexao(dao);
		return result;
	}
	public Collection buscarTipoDesempenhoPorNomeEDescricao(String nomeTipoDesempenho, String descricaoTipoDesempenho) throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =   getDAO().buscarTipoDesempenhoPorNomeEDescricao(nomeTipoDesempenho,descricaoTipoDesempenho);
		fechaConexao(dao);
		return result;
	}
	
	public Collection buscarTodosTiposDesempenho() throws SQLException{
//		abreConexao(getDAO(), dao);
		Collection result;
		result =   getDAO().buscarTodosTiposDesempenho();
		fechaConexao(dao);
		return result;
	}
	public TipoDesempenhoDTO buscarTipoDesempenho(Integer idTipoDesempenho) throws SQLException {
		// TODO Auto-generated method stub
//		abreConexao(getDAO(), dao);
		TipoDesempenhoDTO result;
		result =   getDAO().buscarTipoDesempenho(idTipoDesempenho);
		fechaConexao(dao);
		return result;
	}
	
	public void excluirTipoDesempenho(Integer idTipoDesempenho) throws SQLException {
//		abreConexao(getDAO(), dao);
		getDAO().excluirTipoDesempenho(idTipoDesempenho);
		fechaConexao(dao);
	}
	public void alterarTipoDesempenho(TipoDesempenhoDTO dto) throws SQLException {
//		abreConexao(getDAO(), dao);		
		getDAO().alterarTipoDesempenho(dto);
		fechaConexao(dao);
		
		
	}
	private STITipoDesempenhoDAO getDAO(){
		try {
			dao = (STITipoDesempenhoDAO)DAOFactory.getInstance().getDAO("sti.dao.desempenho.tipo.STITipoDesempenhoDAO",getLoginDTOUsuarioLogado());
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return dao;
	}

















}
