package sti.model.orientacao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import questao.slave.UtilDate;

import model.ConteudoModel;
import model.ModelBase;
import slave.Data;
import sti.apoio.visao.ApoioVisao;
import sti.dao.orientacao.STIOrientacaoDAO;
import sti.dto.acompanhamento.AcompanhamentoDTOSTI;
import sti.dto.orientacao.ApoioViewOrietacao;
import sti.dto.orientacao.OrientacaoDTO;
import sti.dto.regra.RegraDTO;
import sti.dto.sugestoes.SugestaoDTO;
import sti.exceptions.NotFoundDesempenhoEEsforcoNaRegraException;
import sti.exceptions.NotFoundOrientacaoException;
import sti.model.acompanhamento.AcompanhamentoListasModel;
import sti.model.acompanhamento.AcompanhamentoQuestoesModel;
import sti.model.acompanhamento.STIAcompanhamentoModel;
import sti.model.regra.STIRegraModel;
import sti.model.sugestoes.STISugestoesModel;
import sti.tutor.desempenho.Desempenho;
import sti.tutor.desempenho.DesempenhoBusiness;
import sti.tutor.esforco.Esforco;
import sti.tutor.esforco.EsforcoBusiness;
import sti.tutor.resultado.Resultado;
import sti.tutor.resultado.ResultadoBusiness;
import dao.DAOFactory;
import dto.ConteudoDTO;
import dto.LoginDTO;

public class STIOrientacaoModel extends ModelBase{
	private STIOrientacaoDAO dao;
	private LoginDTO login;
	public STIOrientacaoModel(LoginDTO login) {
		super(login);
		this.login = login;
		
	}
	
	
	private Integer chaveAluno;
	private Integer idDisciplina;
	private STIOrientacaoDAO getDAO(){
		try {
			dao = (STIOrientacaoDAO)DAOFactory.getInstance().getDAO("sti.dao.orientacao.STIOrientacaoDAO",getLoginDTOUsuarioLogado());
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return dao;
	}

	public Collection orientarAluno(Integer idDisciplina, Integer chaveAluno) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException, NotFoundDesempenhoEEsforcoNaRegraException {
		this.idDisciplina = idDisciplina;
		this.chaveAluno = chaveAluno;
		ConteudoModel modelConteudo = new ConteudoModel(login);
		Collection orientacoes = new ArrayList();
		Collection conteudosDaDisciplina = modelConteudo.buscarConteudosPorDisciplinaUsandoDTO(idDisciplina);
		ConteudoDTO dto;
		Esforco esforco;
		Desempenho desempenho;
		Resultado resultado;
		OrientacaoDTO ultimaOrientacao;
		for (Iterator element = conteudosDaDisciplina.iterator(); element.hasNext();) {
			 dto = (ConteudoDTO) element.next();
			 esforco = gerarEsforcoPorConteudo(idDisciplina,chaveAluno,dto,Data.getDataInicioDoSemestre(),Data.getDataFinalDoSemestre());
			 desempenho = gerarDesempenhoPorConteudo(idDisciplina,chaveAluno,dto);
			 resultado = gerarResultado(esforco,desempenho);
			 //retornara null se nenhume orientacao existir portanto sera a primeita
			 ultimaOrientacao = getUltimaOrientacao(chaveAluno,idDisciplina,dto.getIdConteudo(),new Integer(Data.getAnoSystem()),new Integer(Data.getSemestreSystem()).toString());
			 validarECadastrarOrientacao(orientacoes,esforco,desempenho,resultado,ultimaOrientacao,dto);
			 if(resultado != null && resultado.getTermo() != null && resultado.getTermo().equalsIgnoreCase("INSATISFATORIO")){
				 ApoioViewOrietacao.setGrauDisparo(-1);//para impedir que o grau de disparo seja inmpresso na jsp
				 return orientacoes;
			 }
				 
		}
		ApoioViewOrietacao.setGrauDisparo(getGrauDeDisparo(orientacoes));
		return orientacoes;
	}
	private void validarECadastrarOrientacao(Collection orientacoes,Esforco esforco, Desempenho desempenho, Resultado resultado, OrientacaoDTO ultimaOrientacao,ConteudoDTO conteudo) throws SQLException, NotFoundDesempenhoEEsforcoNaRegraException {
		STIRegraModel modelRegra = new STIRegraModel(login);
		STISugestoesModel modelSugestao = new STISugestoesModel(login);
		STIAcompanhamentoModel modelAcompanhamento = new STIAcompanhamentoModel(login);
		// RegraDTO - tem as sugestoes da orientacao gerada pelo sistema Atual....
		RegraDTO regra = modelRegra.buscarRegra(desempenho,esforco);
		Collection sugestoesDaUltimaOrientacao = null;
		ApoioViewOrietacao visao = null;
		if(regra == null){//caso o administrador nao tiver feito o cadastro das regras...
			throw new NotFoundDesempenhoEEsforcoNaRegraException();
		}
		if(ultimaOrientacao != null){// o cara tem orientacao
			sugestoesDaUltimaOrientacao = modelSugestao.buscarSugestoesDaOrietacao(ultimaOrientacao.getIdOrientacao());
			System.out.println("VERIFICANDO SE SUGESTOES SAO IGUAIS...");
			if( ! isEquals(regra.getSugestoes(),sugestoesDaUltimaOrientacao)){
				AcompanhamentoDTOSTI acompanhamento = modelAcompanhamento.buscarAcompanhamentoSTI(idDisciplina,new Integer(Data.getAnoSystem()),new Integer(Data.getSemestreSystem()).toString(),chaveAluno);
				OrientacaoDTO orientacao = new OrientacaoDTO();
				putOrientacao(orientacao,acompanhamento,conteudo,resultado);
				System.out.println("Cadastrando NOVA orientacao .... ");
				cadastrarOrietacao(orientacao);
				System.out.println("Cadastrando sugestoes da NOVA orientacao... ");
				orientacao = getUltimaOrientacao(chaveAluno,idDisciplina,conteudo.getIdConteudo(),new Integer(Data.getAnoSystem()),new Integer(Data.getSemestreSystem()).toString());
				System.out.println("Orientacao apos o cadastro "+orientacao.getIdOrientacao());
				cadastrarSugestoesDaOrientacao(orientacao,regra.getSugestoes());
				 visao = new ApoioViewOrietacao(conteudo,regra.getSugestoes(),resultado,orientacao);
			}else{
				visao = new ApoioViewOrietacao(conteudo,regra.getSugestoes(),resultado,ultimaOrientacao);
				System.out.println("Nao foi realizado o cadastro, pois as sugestoes sao iguais...");
			}
		}else{
			try{
				System.out.println("GERANDO PRIMEIRA ORIENTACAO PARA O ALUNO...");
				AcompanhamentoDTOSTI acompanhamento = modelAcompanhamento.buscarAcompanhamentoSTI(idDisciplina,new Integer(Data.getAnoSystem()),new Integer(Data.getSemestreSystem()).toString(),chaveAluno);
				OrientacaoDTO orientacao = new OrientacaoDTO();
				putOrientacao(orientacao,acompanhamento,conteudo,resultado);
				System.out.println("Cadastrando orientacao .... ");
				cadastrarOrietacao(orientacao);
				System.out.println("Cadastrando sugestoes da orientacao... ");
				orientacao = getUltimaOrientacao(chaveAluno,idDisciplina,conteudo.getIdConteudo(),new Integer(Data.getAnoSystem()),new Integer(Data.getSemestreSystem()).toString());
				System.out.println("teste1");
				cadastrarSugestoesDaOrientacao(orientacao,regra.getSugestoes());
				System.out.println("teste2");
				visao = new ApoioViewOrietacao(conteudo,regra.getSugestoes(),resultado,orientacao);
				System.out.println("teste3");
			}catch (Exception e) {
				e.printStackTrace();
				// TODO: handle exception
			}
		}			
		System.out.println("teste4");
		orientacoes.add(visao);
	}
	private void cadastrarSugestoesDaOrientacao(OrientacaoDTO orientacao, Collection sugestoes) throws SQLException {
//		abreConexao(getDAO() , dao);
		getDAO().cadastrarSugestoesDaOrientacao(orientacao,sugestoes);
		fechaConexao(dao);
	}
	public double getGrauDeDisparo(Collection orientacoes){
		double somatorioGrauSatisfatorio = 0.0;
		for (Iterator iter = orientacoes.iterator(); iter.hasNext();) {
			ApoioViewOrietacao element = (ApoioViewOrietacao) iter.next();
			somatorioGrauSatisfatorio+=element.getResultado().getGrauSatisfatorio();
		}
		return somatorioGrauSatisfatorio/orientacoes.size();
	}
	private void cadastrarOrietacao(OrientacaoDTO orientacao) throws SQLException {
//		abreConexao(getDAO(), dao);
		getDAO().cadastrarOrientacao(orientacao);
		fechaConexao(dao);
	}
	private void putOrientacao(OrientacaoDTO orientacao, AcompanhamentoDTOSTI acompanhamento, ConteudoDTO conteudo, Resultado resultado) {
		orientacao.setAcompanhamento(acompanhamento);
		orientacao.setConteudo(conteudo);
		orientacao.setRelativo(resultado.getGrauPertinencia());
		if(resultado.getTermo().equalsIgnoreCase("INSATISFATORIO"))
			orientacao.setSituacao("I");
		else
			orientacao.setSituacao("S");
		//a data e o horario foram setados no momento da criacao do objeto
	}

	private boolean isEquals(Collection sugestoes, Collection sugestoesDaUltimaOrientacao) {
		logCollectionDeVerificacao(sugestoes,sugestoesDaUltimaOrientacao);
		if(sugestoes.size() == sugestoesDaUltimaOrientacao.size()){
			boolean log = sugestoes.containsAll(sugestoesDaUltimaOrientacao);
			if(log){
				System.out.println("Sugestoes Iguais... Nao pode cadastrar...");
			}
			else{
				System.out.println("Sugestoes Diferentes... Tera que fazer o cadastro...");
			}
			return log;
		}
		return false;
	}
	private void logCollectionDeVerificacao(Collection sugestoes, Collection sugestoesDaUltimaOrientacao) {
		System.out.println("********  Sugestoes da ultima orientacao  ***********");
		for (Iterator iter = sugestoesDaUltimaOrientacao.iterator(); iter.hasNext();) {
			SugestaoDTO element = (SugestaoDTO) iter.next();
			if(element.getIdSugestao() instanceof Integer) {
				System.out.print("["+element.getIdSugestao()+"]");
			}
			
		}
		System.out.println("\n********  Sugestoes Achada  ***********");
		for (Iterator iter = sugestoes.iterator(); iter.hasNext();) {
			SugestaoDTO element = (SugestaoDTO) iter.next();
			if(element.getIdSugestao() instanceof Integer) {
				System.out.print("["+element.getIdSugestao()+"]");
			}
		}
	}

	private Resultado gerarResultado(Esforco esforco, Desempenho desempenho) throws SQLException {
		ResultadoBusiness rs = new ResultadoBusiness(esforco,desempenho);
		rs.setLogin(login);
		Resultado resultado = rs.getResultado();
		System.out.println(resultado);
		return resultado;
	}

	private Desempenho gerarDesempenhoPorConteudo(Integer idDisciplina, Integer chaveAluno,ConteudoDTO conteudo) throws SQLException {
		AcompanhamentoQuestoesModel aqm = new AcompanhamentoQuestoesModel(login);
		AcompanhamentoListasModel alm = new AcompanhamentoListasModel(login);
		DesempenhoBusiness db = new DesempenhoBusiness(aqm,alm,chaveAluno,idDisciplina);
		Desempenho desempenho = db.getDesempenho(conteudo);
		System.out.println(desempenho);
		System.gc();
		return desempenho;
	}

	public Esforco gerarEsforcoPorConteudo (Integer idDisciplina, Integer chaveAluno, ConteudoDTO conteudo,String dataInicio,String dataFim) throws SQLException, ClassNotFoundException, InstantiationException, IllegalAccessException{
		getDAO();
			Integer countAtendimento = dao.getQuantidadeDeAtendimento(idDisciplina,chaveAluno,conteudo.getIdConteudo(),dataInicio,dataFim);
			Integer countQuestoes = dao.getQuantidadeDeQuestoesFeitasPeloAluno(idDisciplina,chaveAluno,conteudo.getIdConteudo(),dataInicio,dataFim);
			Esforco esforco  = gerarEsforco(countAtendimento,countQuestoes,conteudo);
			fechaConexao(dao);
			return esforco;
	}
	private Esforco gerarEsforco(Integer countAtendimento,Integer countQuestoes,ConteudoDTO conteudo){
		EsforcoBusiness eb = new EsforcoBusiness(countAtendimento,countQuestoes);
		return eb.getEsforco(conteudo);
	}
	public OrientacaoDTO getUltimaOrientacao(Integer chaveAluno, Integer idDisciplina, Integer idConteudo, Integer ano, String semestre) throws SQLException{
		OrientacaoDTO dto;
//		abreConexao(getDAO(), dao);
		dto =  getDAO().getUltimaOrientacao(chaveAluno,idDisciplina,idConteudo,ano,semestre);
		fechaConexao(dao);
		return dto;
	}
	
	public OrientacaoDTO getOrientacao(Integer idOrientacao) throws SQLException{
		OrientacaoDTO dto;
//		abreConexao(getDAO(), dao);
		dto =  getDAO().getOrientacao(idOrientacao);
		fechaConexao(dao);
		return dto;
	}

	public Collection consultarUltimaOrientacaoAluno(Integer idDisciplina, Integer chaveAluno) throws SQLException, NotFoundOrientacaoException {
		this.idDisciplina = idDisciplina;
		this.chaveAluno = chaveAluno;
		ConteudoModel modelConteudo = new ConteudoModel(login);
		Collection conteudosDaDisciplina = modelConteudo.buscarConteudosPorDisciplinaUsandoDTO(idDisciplina);
		OrientacaoDTO orientacao;
		ConteudoDTO dto;
		Collection orientacoes = new ArrayList(); 
		ApoioViewOrietacao visao;
		for (Iterator iter = conteudosDaDisciplina.iterator(); iter.hasNext();) {
			 dto = (ConteudoDTO) iter.next();
			 orientacao = getUltimaOrientacao(chaveAluno,idDisciplina,dto.getIdConteudo(),new Integer(Data.getAnoSystem()),new Integer(Data.getSemestreSystem()).toString());
			 if(orientacao == null)
				 break;
			 visao = new ApoioViewOrietacao(orientacao,login,dto);
			 orientacoes.add(visao);
			 if(visao.getResultado().getTermo() != null && visao.getResultado().getTermo().equalsIgnoreCase("INSATISFATORIO")){
				 return orientacoes;
			 }
		}
		ApoioViewOrietacao.setGrauDisparo(getGrauDeDisparo(orientacoes));
		return orientacoes;
	}
}
