package sti.model.regra;

import java.sql.SQLException;
import java.util.Collection;

import model.ModelBase;
import sti.dao.regra.STIRegraDAO;
import sti.dto.regra.RegraDTO;
import sti.tutor.desempenho.Desempenho;
import sti.tutor.esforco.Esforco;
import sti.tutor.resultado.Resultado;
import dao.DAOFactory;
import dto.LoginDTO;

public class STIRegraModel extends ModelBase{
	private STIRegraDAO dao;
	public STIRegraModel(LoginDTO login) {
		super(login);
	}

	public void cadastrarRegra(RegraDTO dto) throws SQLException {
//		abreConexao(getDAO(), dao);
		getDAO().cadastrarRegra(dto);
		fechaConexao(dao);
	}
	public void alterarRegra(RegraDTO dto) throws SQLException {
//		abreConexao(getDAO(), dao);
		getDAO().alterarRegra(dto);
		fechaConexao(dao);
	}
	public void excluirRegra(Integer idRegra) throws SQLException {
//		abreConexao(getDAO(), dao);
		getDAO().excluirRegra(idRegra);
		fechaConexao(dao);
	}
	public Resultado buscarResultadoDaRegra(Desempenho desempenho, Esforco esforco) throws SQLException {
//		abreConexao(getDAO(), dao);
		Resultado result;
		result = getDAO().buscarResultadoDaRegra(desempenho,esforco);
		fechaConexao(dao);
		return result;
	}
	public RegraDTO buscarRegra(Desempenho desempenho, Esforco esforco) throws SQLException {
//		abreConexao(getDAO(), dao);
		RegraDTO dto;
		dto = getDAO().buscarRegra(desempenho,esforco);
		fechaConexao(dao);
		return dto;
	}
	
	public RegraDTO buscarRegra(Integer idRegra) throws SQLException {
//		abreConexao(getDAO(), dao);
		RegraDTO dto;
		dto = getDAO().buscarRegra(idRegra);
		fechaConexao(dao);
		return dto;
	}
	public Collection buscarTodasRegras() throws SQLException {
//		abreConexao(getDAO(), dao);
		Collection result;
		result = getDAO().buscarTodasRegras();
		
		fechaConexao(dao);
		return result;
	}
	public Collection buscarRegrasPorSugestao(String sugestao) throws SQLException {
		getDAO();
		Collection result;
		if(sugestao == null || sugestao.equals(""))
			result = dao.buscarTodasRegras();
		else
			result =  dao.buscarRegrasPorSugestao(sugestao);
		
		fechaConexao(dao);
		return result;
	}
	public RegraDTO buscarUltimaRegraInserida() throws SQLException{
//		abreConexao(getDAO(), dao);
		RegraDTO dto;
		dto = getDAO().buscarUltimaRegraInserida();
		fechaConexao(dao);
		return dto;
		
	}
	
	/**
	 * @author Pedro Camara
	 * @param regraDTO
	 * @return verdadeiro ou falso
	 * @throws SQLException
	 * Verifica se j existe no banco de dados alguma regra com a mesma combinao de esforo e
	 * desempenho passados como parametro.
	 */
	public Boolean verificaExistenciaDaRegraPorEsforcoDesempenho(RegraDTO regraDTO) throws SQLException {
		if (getDAO().buscaQtdRegraPorEsforcoDesempenho(regraDTO) != 0) {
			fechaConexao(dao);
			return true;
		}
		fechaConexao(dao);
		return false;
	}
	
	private STIRegraDAO getDAO(){
		try {
			dao = (STIRegraDAO)DAOFactory.getInstance().getDAO("sti.dao.regra.STIRegraDAO",getLoginDTOUsuarioLogado());
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return dao;
	}
}
