package sti.model.sugestoes;

import java.sql.SQLException;
import java.util.Collection;

import model.ModelBase;
import sti.dao.sugestoes.STISugestoesDAO;
import sti.dto.sugestoes.SugestaoDTO;
import dao.DAOFactory;
import dto.LoginDTO;

public class STISugestoesModel extends ModelBase{
	private STISugestoesDAO dao;
	public STISugestoesModel(LoginDTO login) {
		super(login);
		
	}
	public void cadastrarSugestao(SugestaoDTO dto) throws SQLException{
//		abreConexao(getDAO(), dao);
		getDAO().cadastrarSugestao(dto);
		fechaConexao(dao);

	}
	public SugestaoDTO getUltimoInserido() throws SQLException{
			SugestaoDTO dto;
//			abreConexao(getDAO(), dao);
			dto = getDAO().getUltimoInserido();
			fechaConexao(dao);
			return dto;
	}
	public Collection buscarSugestoesDoContexto(String contexto) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result = getDAO().buscarSugestoesContexto(contexto);
		fechaConexao(dao);
		return result;
			
	}
	public Collection buscarTodasSugestoes() throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result = getDAO().buscarTodasSugestoes();
		fechaConexao(dao);
		return result;
		
		
	}
	public Collection filtraBusca(SugestaoDTO dto) throws SQLException{
		Collection result;
		getDAO();
		
		if (dto.getSugestao().equalsIgnoreCase(""))
			if(dto.getContexto().equalsIgnoreCase(""))
				result =  dao.buscarTodasSugestoes();
			else
				result =  dao.buscarSugestoesContexto(dto.getContexto());
		else
			if(dto.getContexto().equalsIgnoreCase(""))
				result =  dao.buscarSugestoes(dto.getSugestao());
			else
				result =  dao.buscarSugestoesContextoSugestao(dto);
		
		fechaConexao(dao);
		return result;
	}
	public SugestaoDTO buscarSugestao(Integer idSugestao) throws SQLException {
		SugestaoDTO dto;
//		abreConexao(getDAO(), dao);
		dto = getDAO().buscarSugestao(idSugestao);
		fechaConexao(dao);
		return dto;
		
	}
	public Collection buscarSugestoesDoContextoESugestao(SugestaoDTO dto) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result = getDAO().buscarSugestoesContextoSugestao(dto);
		fechaConexao(dao);
		return result;
		
	}
	
	public void excluirSugestao(Integer idSugestao) throws SQLException{
//		abreConexao(getDAO(), dao);
		getDAO().excluirSugestao(idSugestao);
		fechaConexao(dao);
	}
	
	public void alterarSugestao(SugestaoDTO dto) throws SQLException {
//		abreConexao(getDAO(), dao);
		getDAO().alterarSugestao(dto);
		fechaConexao(dao);
	}
	public Collection buscarSugestoesDaOrietacao(Integer idOrientacao) throws SQLException{
		Collection result;
//		abreConexao(getDAO(), dao);
		result = getDAO().buscarSugestoes(idOrientacao);
		fechaConexao(dao);
		return result;
	}
	
	private STISugestoesDAO getDAO(){
		try {
			dao = (STISugestoesDAO)DAOFactory.getInstance().getDAO("sti.dao.sugestoes.STISugestoesDAO",getLoginDTOUsuarioLogado());
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (SQLException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return dao;
	}


}
