package sti.tutor.desempenho;

import java.sql.SQLException;

import sti.model.acompanhamento.AcompanhamentoListasModel;
import sti.model.acompanhamento.AcompanhamentoQuestoesModel;
import sti.tutor.desempenho.notas.NotaCategoria;
import sti.tutor.desempenho.notas.NotaDificuldade;
import sti.tutor.desempenho.notas.NotaTipo;
import sti.tutor.formulas.MathBusinessDesempenho;
import sti.tutor.formulas.MathDesempenho;
import dto.ConteudoDTO;

public class DesempenhoBusiness {

	private DesempenhoServiceQuestoes service;
	private NotaTipo notaTipo;
	private NotaCategoria notaCategoria;
	private NotaDificuldade notaDificuldade;
	
	public DesempenhoBusiness(AcompanhamentoQuestoesModel modelAvulsas,AcompanhamentoListasModel modelListas,Integer chaveAluno, Integer idDisciplina) throws SQLException {
		service = new DesempenhoServiceQuestoes(modelAvulsas,modelListas,chaveAluno,idDisciplina);;
		notaTipo = new NotaTipo(service);
		notaCategoria = new NotaCategoria(service);
		notaDificuldade = new NotaDificuldade(service);
	}
	public Desempenho getDesempenho(ConteudoDTO dto) throws SQLException {
			service.setDto(dto);
			return new MathBusinessDesempenho(new MathDesempenho()).getDesempenhoMax(getNumberMagic());
	}
	private double getNumberMagic(){
		double notaCat = notaCategoria.getNotaCategoriaQuestoes();
		
		double notaDif = notaDificuldade.getNotaDificuldadeQuestoes();
		
		double notaTIp = notaTipo.getNotaTipoQuestoes();
		
		double notaMagic =  notaCat * notaCategoria.PESO_NOTA_CATEGORIA + notaDif * notaDificuldade.PESO_NOTA_DIFICULDADE + notaTIp* notaTipo.PESO_NOTA_TIPO;
		System.out.println("Nota Categoria ["+notaCat+"] * Peso ["+notaTipo.PESO_NOTA_TIPO+"] = Parcial Categoria ["+notaCat * notaCategoria.PESO_NOTA_CATEGORIA+"]");
		System.out.println("Nota Dificuldade ["+notaDif+"] * Peso ["+notaDificuldade.PESO_NOTA_DIFICULDADE+"] = Parcial Dificuldade ["+notaDif * notaDificuldade.PESO_NOTA_DIFICULDADE+"]");
		System.out.println("Nota Tipo ["+notaTIp+"] * Peso ["+notaTipo.PESO_NOTA_TIPO+"] = Parcial Tipo ["+notaTIp * notaTipo.PESO_NOTA_TIPO+"]");
		System.out.println("(Numero Magico Desempenho)Nota Magica (ITA): "+notaMagic);
		
		return notaMagic;
	}
}
