package sti.tutor.desempenho;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;

import dto.ConteudoDTO;

import sti.dto.acompanhamento.AcompanhamentoDTO;
import sti.model.acompanhamento.AcompanhamentoListasModel;
import sti.model.acompanhamento.AcompanhamentoQuestoesModel;
import sti.tutor.desempenho.questao.Questao;
import sti.tutor.desempenho.questao.QuestionInterface;


abstract class DesempenhoQuestoes {
	private AcompanhamentoListasModel modelListas;
	private AcompanhamentoQuestoesModel modelAvulsas;
	
	private Questao certasVouf;
	private Questao erradasVouf;
	
	private Questao certasMultipla;
	private Questao erradasMultipla;
	
	private Questao erradasEscolha;
	private Questao certasEscolha;

	private Questao erradasLacuna;
	private Questao certasLacuna;

	private Questao erradasAberta;
	private Questao certasAberta;
	
	private ConteudoDTO dto;

	private Integer chaveAluno;
	private Integer idDisciplina;


	
	public DesempenhoQuestoes(AcompanhamentoQuestoesModel modelAvulsas,AcompanhamentoListasModel modelListas,Integer chaveAluno, Integer idDisciplina) throws SQLException {
		this.modelListas = modelListas;
		this.modelAvulsas = modelAvulsas;
		this.chaveAluno = chaveAluno;
		this.idDisciplina = idDisciplina;
	}
	protected void init(ConteudoDTO dto) throws SQLException {
		initQuestoes();
		getQuestoesCertasEErradasConteudoDaDisciplinaVouF(dto);
		getQuestoesCertasEErradasConteudoDaDisciplinaEscolha(dto);
		getQuestoesCertasEErradasConteudoDaDisciplinaLacuna(dto);
		getQuestoesCertasEErradasConteudoDaDisciplinaMultipla(dto);
		getQuestoesCertasEErradasConteudoDaDisciplinaAberta(dto);
	}
	
	private void initQuestoes() {
		certasVouf = new Questao();
		erradasVouf = new Questao();
		
		certasMultipla = new Questao();
		erradasMultipla = new Questao();
		
		erradasEscolha = new Questao();
		certasEscolha = new Questao();

		erradasLacuna = new Questao();
		certasLacuna = new Questao();

		erradasAberta = new Questao();
		certasAberta = new Questao();
		
	}
	public ConteudoDTO getDto() {
		return dto;
	}
	public void setDto(ConteudoDTO dto) throws SQLException {
		this.dto = dto;
		initQuestoes();
		init(dto);
	}
	private void getQuestoesCertasEErradasConteudoDaDisciplinaVouF(ConteudoDTO dto) throws SQLException{
		Collection certas = new ArrayList();
		Collection erradas = new ArrayList();
		certas.addAll(modelListas.buscarQuestoesListasVouFCertasPorConteudo(chaveAluno,idDisciplina,dto.getIdConteudo()));
		certas.addAll(modelAvulsas.buscarQuestoesAvulsasVouFCertas(chaveAluno,idDisciplina,dto.getIdConteudo()));
		
		erradas.addAll(modelListas.buscarQuestoesListasVouFErradasPorConteudo(chaveAluno,idDisciplina,dto.getIdConteudo()));
		erradas.addAll(modelAvulsas.buscarQuestoesAvulsasVouFErradas(chaveAluno,idDisciplina,dto.getIdConteudo()));
	
		realizaContagemDasQuestoes(certas,certasVouf);

		realizaContagemDasQuestoes(erradas,erradasVouf);
	}
	private void getQuestoesCertasEErradasConteudoDaDisciplinaMultipla(ConteudoDTO dto) throws SQLException{
		Collection certas = new ArrayList();
		Collection erradas = new ArrayList();
		
		certas.addAll(modelListas.buscarQuestoesListasMultiplasCertasPorConteudo(chaveAluno,idDisciplina,dto.getIdConteudo()));
		certas.addAll(modelAvulsas.buscarQuestoesAvulsasMultiplasCertas(chaveAluno,idDisciplina,dto.getIdConteudo()));
		erradas.addAll(modelListas.buscarQuestoesListasMultiplasErradasPorConteudo(chaveAluno,idDisciplina,dto.getIdConteudo()));
		erradas.addAll(modelAvulsas.buscarQuestoesAvulsasMultiplasErradas(chaveAluno,idDisciplina,dto.getIdConteudo()));

		realizaContagemDasQuestoes(certas,certasMultipla);

		realizaContagemDasQuestoes(erradas,erradasMultipla);
	}

	private void getQuestoesCertasEErradasConteudoDaDisciplinaEscolha(ConteudoDTO dto) throws SQLException{
		Collection certas = new ArrayList();
		Collection erradas = new ArrayList();

		certas.addAll(modelListas.buscarQuestoesListasEscolhasCertasPorConteudo(chaveAluno,idDisciplina,dto.getIdConteudo()));
		certas.addAll(modelAvulsas.buscarQuestoesAvulsasEscolhasCertas(chaveAluno,idDisciplina,dto.getIdConteudo()));
		erradas.addAll(modelListas.buscarQuestoesListasEscolhasErradasPorConteudo(chaveAluno,idDisciplina,dto.getIdConteudo()));
		erradas.addAll(modelAvulsas.buscarQuestoesAvulsasEscolhasErradas(chaveAluno,idDisciplina,dto.getIdConteudo()));
		
		realizaContagemDasQuestoes(certas,certasEscolha);
		realizaContagemDasQuestoes(erradas,erradasEscolha);

	}
	private void getQuestoesCertasEErradasConteudoDaDisciplinaLacuna(ConteudoDTO dto) throws SQLException{
		Collection certas = new ArrayList();
		Collection erradas = new ArrayList();
		
		certas.addAll(modelListas.buscarQuestoesListasLacunasCertasPorConteudo(chaveAluno,idDisciplina,dto.getIdConteudo()));
		certas.addAll(modelAvulsas.buscarQuestoesAvulsasLacunasCertas(chaveAluno,idDisciplina,dto.getIdConteudo()));
		erradas.addAll(modelListas.buscarQuestoesListasLacunasErradasPorConteudo(chaveAluno,idDisciplina,dto.getIdConteudo()));
		erradas.addAll(modelAvulsas.buscarQuestoesAvulsasLacunasErradas(chaveAluno,idDisciplina,dto.getIdConteudo()));
		realizaContagemDasQuestoes(certas,certasLacuna);
		realizaContagemDasQuestoes(erradas,erradasLacuna);
	}
	private void getQuestoesCertasEErradasConteudoDaDisciplinaAberta(ConteudoDTO dto) throws SQLException{
		Collection certas = new ArrayList();
		Collection erradas = new ArrayList();
		
		certas.addAll(modelListas.buscarQuestoesListasAbertasCertasPorConteudo(chaveAluno,idDisciplina,dto.getIdConteudo()));
		certas.addAll(modelAvulsas.buscarQuestoesAvulsasAbertasCertas(chaveAluno,idDisciplina,dto.getIdConteudo()));
		erradas.addAll(modelListas.buscarQuestoesListasAbertasErradasPorConteudo(chaveAluno,idDisciplina,dto.getIdConteudo()));
		erradas.addAll(modelAvulsas.buscarQuestoesAvulsasAbertasErradas(chaveAluno,idDisciplina,dto.getIdConteudo()));
		
		realizaContagemDasQuestoes(certas,certasAberta);
		realizaContagemDasQuestoes(erradas,erradasAberta);
	}
	private void realizaContagemDasQuestoes(Collection questoes,QuestionInterface questao) {
//		System.out.println("*********( DESEMEPENHO BUSINNES ) ********");
		for (Iterator iter = questoes.iterator(); iter.hasNext();) {
			AcompanhamentoDTO element = (AcompanhamentoDTO) iter.next();
			if(element.getQuestaoDTO().getDificuldade().equalsIgnoreCase("F")){
				questao.incrementFacil();
			}else {
				if(element.getQuestaoDTO().getDificuldade().equalsIgnoreCase("M"))
					questao.incrementMedio();
				else questao.incrementDificil();
			}
			if(element.getQuestaoDTO().getCategoria().equalsIgnoreCase("A"))
				questao.incrementAvaliativa();
			else if(element.getQuestaoDTO().getCategoria().equalsIgnoreCase("F"))
				questao.incrementFixacao();
			else questao.incrementRevisao();
		}
		//System.out.println("********* (FIM DESEMEPENHO BUSINNES ) ********");
	}
	public Questao getCertasAberta() {
		return certasAberta;
	}
	public void setCertasAberta(Questao certasAberta) {
		this.certasAberta = certasAberta;
	}
	public Questao getCertasEscolha() {
		return certasEscolha;
	}
	public void setCertasEscolha(Questao certasEscolha) {
		this.certasEscolha = certasEscolha;
	}
	public Questao getCertasLacuna() {
		return certasLacuna;
	}
	public void setCertasLacuna(Questao certasLacuna) {
		this.certasLacuna = certasLacuna;
	}
	public Questao getCertasMultipla() {
		return certasMultipla;
	}
	public void setCertasMultipla(Questao certasMultipla) {
		this.certasMultipla = certasMultipla;
	}
	public Questao getCertasVouf() {
		return certasVouf;
	}
	public void setCertasVouf(Questao certasVouf) {
		this.certasVouf = certasVouf;
	}
	public Questao getErradasAberta() {
		return erradasAberta;
	}
	public void setErradasAberta(Questao erradasAberta) {
		this.erradasAberta = erradasAberta;
	}
	public Questao getErradasEscolha() {
		return erradasEscolha;
	}
	public void setErradasEscolha(Questao erradasEscolha) {
		this.erradasEscolha = erradasEscolha;
	}
	public Questao getErradasLacuna() {
		return erradasLacuna;
	}
	public void setErradasLacuna(Questao erradasLacuna) {
		this.erradasLacuna = erradasLacuna;
	}
	public Questao getErradasMultipla() {
		return erradasMultipla;
	}
	public void setErradasMultipla(Questao erradasMultipla) {
		this.erradasMultipla = erradasMultipla;
	}
	public Questao getErradasVouf() {
		return erradasVouf;
	}
	public void setErradasVouf(Questao erradasVouf) {
		this.erradasVouf = erradasVouf;
	}
	public Integer getChaveAluno() {
		return chaveAluno;
	}
	public void setChaveAluno(Integer chaveAluno) {
		this.chaveAluno = chaveAluno;
	}
	public Integer getIdDisciplina() {
		return idDisciplina;
	}
	public void setIdDisciplina(Integer idDisciplina) {
		this.idDisciplina = idDisciplina;
	}
}
