package sti.tutor.desempenho.notas;

import sti.tutor.desempenho.DesempenhoServiceQuestoes;
import sti.tutor.desempenho.peso.PesoCategoria;

public class NotaCategoria {
	private DesempenhoServiceQuestoes service;
	public final double PESO_NOTA_CATEGORIA = 0.3;
	public NotaCategoria(DesempenhoServiceQuestoes service) {
		this.service = service;
	}
	public double getNotaCategoriaQuestoes(){
		System.out.println("Conteudo :"+service.getDto().getDescricao());
		
		double certasFixacao = service.getCertasFixacao().doubleValue();
		System.out.println("Certas Fixacao["+certasFixacao+"]");

		double certasRevisao = service.getCertasRevisao().doubleValue();
		System.out.println("Certas revisao["+certasRevisao+"]");

		double certasAvaliativa = service.getCertasAvaliativa().doubleValue();
		System.out.println("Certas Avaliacao["+certasAvaliativa+"]");
		
		double todasFixacao = service.getTodasFixacao().doubleValue();
		System.out.println("Todas Fixacao["+todasFixacao+"]");

		double todasRevisao = service.getTodasRevisao().doubleValue();
		System.out.println("Todas Revisao["+todasRevisao+"]");

		double todasAvaliativa = service.getTodasAvaliativa().doubleValue();
		System.out.println("Todas Avaliacao["+todasAvaliativa+"]");
		double resultFixacao = 0.0;
		if(todasFixacao > 0.0) // Impedindo divisao por zero
			 resultFixacao = certasFixacao / todasFixacao * PesoCategoria.FIXACAO;
		double resultRevisao = 0.0;
		if(todasRevisao > 0.0)
			resultRevisao = certasRevisao / todasRevisao * PesoCategoria.REVISAO;
		
		double resultAvaliativa = 0.0;
		if(todasAvaliativa > 0.0)
			resultAvaliativa = certasAvaliativa / todasAvaliativa * PesoCategoria.AVALIATIVA;
		
		double notaCategoria = (resultFixacao+ resultRevisao + resultAvaliativa);
		StringBuffer sb = new StringBuffer();
		sb.append("Certas Fixacao["+certasFixacao+"] / Todas Fixacao["+todasFixacao+"] * Peso Fixacao["+PesoCategoria.FIXACAO+"] = "+resultFixacao+"\n");
		sb.append("Certas Revisao["+certasRevisao+"] / Todas Revisao["+todasRevisao+"] * Peso Revisao["+PesoCategoria.REVISAO+"]= "+resultRevisao+"\n");
		sb.append("Certas Avaliativa["+certasAvaliativa+"] / Todas Avaliativa["+todasAvaliativa+"] * Peso Avaliativa["+PesoCategoria.AVALIATIVA+"]= "+resultAvaliativa+"\n");
		sb.append("Fixacao["+resultFixacao+"] + Revisao["+resultRevisao+"] + Avaliativa ["+resultAvaliativa+"]= Nota Categoria["+notaCategoria+"]\n");
		System.out.println(sb);
		
		
		return notaCategoria;
	}
}