package sti.tutor.desempenho.notas;

import sti.tutor.desempenho.DesempenhoServiceQuestoes;
import sti.tutor.desempenho.peso.PesoTipo;


public class NotaTipo {
	private DesempenhoServiceQuestoes service;
	public final double PESO_NOTA_TIPO = 0.3;
	
	public NotaTipo(DesempenhoServiceQuestoes service) {
		this.service = service;
	}
	public double getNotaTipoQuestoes(){
		System.out.println("Conteudo: "+service.getDto().getDescricao());
		
		double certasVouf = service.getVouFCertas().doubleValue();
		System.out.println("Certas Vouf["+certasVouf+"]");
		
		double certasMultiplas = service.getMultiplaCertas().doubleValue();
		System.out.println("Certas Multiplas["+certasMultiplas+"]");
		
		double certasEscolhas = service.getEscolhaCertas().doubleValue();
		System.out.println("Certas Escolhas["+certasEscolhas+"]");

		double certasLacuna = service.getLacunaCertas().doubleValue();
		System.out.println("Certas Lacuna["+certasLacuna+"]");
		
		double certasAberta = service.getAbertaCertas().doubleValue();
		System.out.println("Certas Aberta["+certasAberta+"]");

		double todasVouf = service.getVouFTodas().doubleValue();
		System.out.println("Todas Vouf["+todasVouf+"]");
		
		double todasMultiplas = service.getMultiplaTodas().doubleValue();
		System.out.println("Todas Multiplas["+todasMultiplas+"]");
		
		double todasEscolhas = service.getEscolhaTodas().doubleValue();
		System.out.println("Todas Escolhas["+todasEscolhas+"]");
		
		double todasLacuna = service.getLacunaTodas().doubleValue();
		System.out.println("Todas Lacuna["+todasLacuna+"]");
		
		double todasAberta = service.getAbertaTodas().doubleValue();
		System.out.println("Todas Aberta["+todasAberta+"]");
		double resultVouf = 0.0;
		if(todasVouf > 0.0)
			resultVouf = certasVouf / todasVouf * PesoTipo.V_OU_F;
		double resultMultipla = 0.0;
		if(todasMultiplas > 0.0)
			resultMultipla = certasMultiplas / todasMultiplas * PesoTipo.MULTIPLA;
		double resultEscolha = 0.0;
		if(todasEscolhas > 0.0)
			resultEscolha = certasEscolhas / todasEscolhas * PesoTipo.ESCOLHA;
		double resultLacuna = 0.0;
		if(todasLacuna > 0.0)
			resultLacuna = certasLacuna / todasLacuna * PesoTipo.LACUNAS;
		double resultAberta = 0.0;
		if(todasAberta > 0.0) 
			resultAberta = certasAberta / todasAberta * PesoTipo.ABERTA;
		double notaTipo =  (resultVouf + resultMultipla + resultEscolha + resultLacuna + resultAberta);
		StringBuffer sb = new StringBuffer();
		sb.append("Certas VouF["+certasVouf+"] / Todas Vouf["+todasVouf+"] * Peso VouF["+PesoTipo.V_OU_F+"] = "+resultVouf+"\n");
		sb.append("Certas Multipla["+certasMultiplas+"] / Todas Multipla["+todasMultiplas+"] * Peso Multipla["+PesoTipo.MULTIPLA+"] = "+resultMultipla+"\n");
		sb.append("Certas Escolha["+certasEscolhas+"] / Todas Escolhas["+todasEscolhas+"] * Peso Escolha["+PesoTipo.ESCOLHA+"] = "+resultEscolha+"\n");
		sb.append("Certas Lacuna["+certasLacuna+"] / Todas Lacuna["+todasLacuna+"] * Peso Lacuna["+PesoTipo.LACUNAS+"]= "+resultLacuna+"\n");
		sb.append("Certas Aberta["+certasAberta+"] / Todas Aberta["+todasAberta+"] * Peso Aberta["+PesoTipo.ABERTA+"] = "+resultAberta+"\n");
		sb.append("VouF["+resultVouf+"] + Multipla["+resultMultipla+"] + Escolha["+resultEscolha+"] + Lacuna["+resultLacuna+"] + Aberta["+resultAberta+"] = Nota Tipo["+notaTipo+"]\n");
		System.out.println(sb);
		
		return notaTipo;
	}
}
