package sti.tutor.esforco;

import dto.ConteudoDTO;
import slave.Data;
import sti.tutor.formulas.MathBusinessEsforco;
import sti.tutor.formulas.MathEsforco;
import sti.tutor.termo.FactoryTermo;
import sti.tutor.termo.TermoGeneric;
import sti.tutor.termo.linguistico.TermoLinguistico;
import sti.tutor.termo.linguistico.esforco.TermoEsforcoMonitoria;
import sti.tutor.termo.linguistico.esforco.TermoEsforcoQuestoes;

public class EsforcoBusiness {
	private TermoLinguistico termoMonitoria;
	private TermoLinguistico termoQuestoes;
	private String dataInicio;
	private String dataFim;
	private Integer countAtendimento;
	private	Integer countQuestoes;
	public Integer getCountAtendimento() {
		return countAtendimento;
	}
	public void setCountAtendimento(Integer countAtendimento) {
		this.countAtendimento = countAtendimento;
	}
	public Integer getCountQuestoes() {
		return countQuestoes;
	}
	public void setCountQuestoes(Integer countQuestoes) {
		this.countQuestoes = countQuestoes;
	}
	public EsforcoBusiness(Integer countAtendimento,Integer countQuestoes) {
		
		setDataInicio(Data.getDataInicioDoSemestre());
		setDataFim(Data.getDataFinalDoSemestre());
		setCountAtendimento(countAtendimento);
		setCountQuestoes(countQuestoes);
	}


	public Esforco getEsforco(ConteudoDTO dto){
		setTermoLinguisticoMonitoria(dto);//EX: BAIXO - 1.0
		setTermoLinguisticoQuestoes(dto);//EX: MEDIO - 3.0
//		System.out.println("***** Esforco ****");
//		System.out.println("Conteudo :"+dto.getDescricao());
//		System.out.println(" Termo Linguistico Monitoria ");
//		System.out.println(getTermoMonitoria().getTermo());
//		System.out.println(getTermoMonitoria().getValor());
//		System.out.println(" Termo Linguistico Questoes ");
//		System.out.println(getTermoQuestoes().getTermo());
//		System.out.println(getTermoQuestoes().getValor());
//		System.out.println("Peso Monitoria ["+getTermoMonitoria().getValor()+"] + Peso Questoes ["+getTermoQuestoes().getValor()+"] =  Magic Number :"+getNumberMagic());
		Esforco esforco = new MathBusinessEsforco(new MathEsforco()).getEsforcoMax(getNumberMagic());
		System.out.println("Monitoria do Contedo - "+dto.getMonitoria());
		System.out.println("Questoes do Contedo - "+dto.getQuestoes());
		System.out.println("Contagem de Monitoria - "+countAtendimento);
		System.out.println("Contagem de Questoes - "+countQuestoes);
		System.out.println("************ Esforco ***********");
		System.out.println(esforco);
		return esforco;
	}

	public void setTermoLinguisticoQuestoes(ConteudoDTO dto){
		setTermoQuestoes(((TermoEsforcoQuestoes)getTermo(dto,"sti.tutor.termo.linguistico.esforco.TermoEsforcoQuestoes")).getTermoLinguistico(dto,countQuestoes));
	}
	public void setTermoLinguisticoMonitoria(ConteudoDTO dto){
		setTermoMonitoria(((TermoEsforcoMonitoria)getTermo(dto,"sti.tutor.termo.linguistico.esforco.TermoEsforcoMonitoria")).getTermoLinguistico(dto,countAtendimento));
	}
	public double getNumberMagic(TermoLinguistico termoMonitoria, TermoLinguistico termoQuestoes){
		return getTermoMonitoria().getValor()+getTermoQuestoes().getValor();
	}
	public double getNumberMagic(){
		double numberMagic = getTermoMonitoria().getValor()+getTermoQuestoes().getValor();
		System.out.println(" Number Magic do Esforco - "+numberMagic);
		return numberMagic;
	}
	
	
	
	
	
	
	
	
	
	
	
	private TermoGeneric getTermo(ConteudoDTO dto,String nameClass){
		try {
			return ((TermoGeneric)FactoryTermo.getInstance().getTermo(nameClass));
		} catch (ClassNotFoundException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (InstantiationException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		} catch (IllegalAccessException e) {
			// TODO Auto-generated catch block
			e.printStackTrace();
		}
		return null;
	}
	
	public TermoLinguistico getTermoMonitoria() {
		return termoMonitoria;
	}
	public void setTermoMonitoria(TermoLinguistico termoMonitoria) {
		this.termoMonitoria = termoMonitoria;
	}
	public TermoLinguistico getTermoQuestoes() {
		return termoQuestoes;
	}
	public void setTermoQuestoes(TermoLinguistico termoQuestoes) {
		this.termoQuestoes = termoQuestoes;
	}
	
	public String getDataFim() {
		return dataFim;
	}
	public void setDataFim(String dataFim) {
		this.dataFim = dataFim;
	}
	public String getDataInicio() {
		return dataInicio;
	}
	public void setDataInicio(String dataInicio) {
		this.dataInicio = dataInicio;
	}
}