package sti.tutor.formulas;

import sti.tutor.desempenho.Desempenho;

public class MathBusinessDesempenho {
	private MathDesempenho math;
	public MathBusinessDesempenho(MathDesempenho math) {
		this.math = math;
	}
	public Desempenho desempenhoFraco(double numberMagic) {
		Desempenho desempenho = new Desempenho();
		desempenho.setGrauPertinencia(math.pertinenciaFraco(numberMagic));
		desempenho.setTermo("FRACO");
		return desempenho;
	}
	public Desempenho desempenhoRazoavel(double numberMagic) {
		Desempenho desempenho = new Desempenho();
		desempenho.setGrauPertinencia(math.pertinenciaRazoavel(numberMagic));
		desempenho.setTermo("RAZOAVEL");
		return desempenho;
	}
	public Desempenho desempenhoBom(double numberMagic) {
		Desempenho desempenho = new Desempenho();
		desempenho.setGrauPertinencia(math.pertinenciaBom(numberMagic));
		desempenho.setTermo("BOM");
		return desempenho;
	}
	public Desempenho getDesempenhoMax(double numberMagic) {
		if(desempenhoBom(numberMagic).getGrauPertinencia() > desempenhoRazoavel(numberMagic).getGrauPertinencia())
			if(desempenhoBom(numberMagic).getGrauPertinencia() > desempenhoFraco(numberMagic).getGrauPertinencia())
				return desempenhoBom(numberMagic);
			else
				return desempenhoFraco(numberMagic);
		else if(desempenhoRazoavel(numberMagic).getGrauPertinencia() > desempenhoFraco(numberMagic).getGrauPertinencia())
				return desempenhoRazoavel(numberMagic);
		else return desempenhoFraco(numberMagic);
			
	}

}
