package sti.tutor.formulas;

import sti.tutor.desempenho.Desempenho;
import sti.tutor.esforco.Esforco;

public class MathBusinessResultado {
	private MathResultado math;
	public MathBusinessResultado(MathResultado math) {
		this.math = math;
	}

	public double getRelativoDesempenho(Desempenho desempenho){
		if(desempenho.getTermo() != null && desempenho.getTermo().equalsIgnoreCase("FRACO")){
			return (math.getRelativoDesemepnhoFraco(desempenho));
		}else if(desempenho.getTermo() != null && desempenho.getTermo().equalsIgnoreCase("RAZOAVEL")){
			return (math.getRelativoDesemepnhoRazoavel(desempenho));
		}else if(desempenho.getTermo() != null && desempenho.getTermo().equalsIgnoreCase("BOM")){
			return (math.getRelativoDesemepnhoBom(desempenho));
		}
		return -1;
	}
	public  double getRelativoEsforco(Esforco esforco){
		if(esforco.getTermo() != null && esforco.getTermo().equalsIgnoreCase("BAIXO")){
			return (math.getRelativoEsforcoBaixo(esforco));
		}else if(esforco.getTermo() != null && esforco.getTermo().equalsIgnoreCase("MEDIO")){
			return (math.getRelativoEsforcoMedio(esforco));
		}else if(esforco.getTermo() != null && esforco.getTermo().equalsIgnoreCase("ALTO")){
			return (math.getRelativoEsforcoAlto(esforco));
		}
		return -1;
	}
	public  double getValorRelativo(Desempenho desempenho, Esforco esforco){
		return getRelativoDesempenho(desempenho) + getRelativoEsforco(esforco);
	}

	public double getGrauSatisfatorio(double valorRelativo) {
		return 	   (0.002209486898+(0.2393247106*valorRelativo)-(0.2939870561*(Math.pow(valorRelativo,2)))+
			       (0.1447862596*(Math.pow(valorRelativo,3)))-(0.02634090467*(Math.pow(valorRelativo,4)))+
			       (0.0005043943843*(Math.pow(valorRelativo,5)))+(0.0004038777723*(Math.pow(valorRelativo,6)))-
			       (0.00004623993339*(Math.pow(valorRelativo,7)))+(0.000001547099395*(Math.pow(valorRelativo,8))));
	}
}
