package sti.tutor.formulas;

import sti.tutor.desempenho.Desempenho;
import sti.tutor.esforco.Esforco;

public class MathResultado {
	private static final double PESO_BAIXO = 1.0;
	private static final double PESO_MEDIO = 2.0;
	private static final double PESO_ALTO = 3.0;
	private static final double PESO_FRACO = 1.0;
	private static final double PESO_RAZOAVEL = 3.0;;
	private static final double PESO_BOM = 5.0;
	public double getRelativoEsforcoBaixo(Esforco esforco){
		return esforco.getGrauPertinencia() + (1.0 * PESO_BAIXO);
	}
	public double getRelativoEsforcoMedio(Esforco esforco){
		return esforco.getGrauPertinencia() + (1.0 * PESO_MEDIO);
	}
	public double getRelativoEsforcoAlto(Esforco esforco){
		return esforco.getGrauPertinencia() + (1.0 * PESO_ALTO);
	}
	public double getRelativoDesemepnhoFraco(Desempenho desempenho){
		return desempenho.getGrauPertinencia() + (1.0 * PESO_FRACO);
	}
	public double getRelativoDesemepnhoRazoavel(Desempenho desempenho){
		return desempenho.getGrauPertinencia() + (1.0 * PESO_RAZOAVEL);
	}
	public double getRelativoDesemepnhoBom(Desempenho desempenho){
		return desempenho.getGrauPertinencia() + (1.0 * PESO_BOM);
	}
}
