package sti.tutor.resultado;

import java.text.NumberFormat;
import mina.dto.AnimationDTO;

public class Resultado {
	private String termo;
	private double grauPertinencia;
	private double grauSatisfatorio;
	private AnimationDTO animation;
	
	public  String getGrauSatisfatorioString() {
		NumberFormat nf = NumberFormat.getInstance();
		nf.setMaximumFractionDigits(2);
		return nf.format(grauSatisfatorio);
	}
	public Resultado(String termo, double grauPertinencia) {
		setTermo(termo);
		setGrauPertinencia(grauPertinencia);
	}
	public Resultado() {}
	
	
	public String getTermo() {
		return termo;
	}
	public void setTermo(String termo) {
		this.termo = termo;
	}
	public double getGrauPertinencia() {
		return grauPertinencia;
	}
	public void setGrauPertinencia(double grauPertinencia) {
		this.grauPertinencia = grauPertinencia;
	}
	public String toString() {
		
		return "***** Resultado ****** \n Termo: "+getTermo()+"\nGrau Pertinencia: "+getGrauPertinencia();
	}
	public double getGrauSatisfatorio() {
		return grauSatisfatorio;
	}
	public void setGrauSatisfatorio(double grauSatisfatorio) {
		this.grauSatisfatorio = grauSatisfatorio;
	}
	
	public void setAnimation(AnimationDTO animation)
	{
		this.animation = animation;
	}
	
	public AnimationDTO getAnimation()
	{
		return this.animation;
	}
}
