package sti.tutor.resultado;

import java.sql.SQLException;

import sti.model.regra.STIRegraModel;
import sti.tutor.desempenho.Desempenho;
import sti.tutor.esforco.Esforco;
import sti.tutor.formulas.MathBusinessResultado;
import sti.tutor.formulas.MathResultado;
import dto.LoginDTO;

public class ResultadoBusiness {
	private Esforco esforco;
	private Desempenho desempenho;
	private LoginDTO login;
	private STIRegraModel regraModel;
	private Resultado resultado;
	public ResultadoBusiness(Esforco esforco,Desempenho desempenho) {
		setDesempenho(desempenho);
		setEsforco(esforco);
	}
	
	public Resultado getResultado() throws SQLException{
		try{
			resultado = regraModel.buscarResultadoDaRegra(desempenho,esforco);
		}catch (NullPointerException e) {
			System.out.println("Voce deve setar o login com o metodo setLogin(LoginDTO)");
			e.printStackTrace();
		}
		MathBusinessResultado mbr = new MathBusinessResultado(new MathResultado());
		resultado.setGrauPertinencia(mbr.getValorRelativo(desempenho,esforco));
		if(resultado != null && resultado.getTermo() != null && resultado.getTermo().equalsIgnoreCase("SATISFATORIO"))
			resultado.setGrauSatisfatorio(mbr.getGrauSatisfatorio(resultado.getGrauPertinencia()));
		else
			resultado.setGrauSatisfatorio(1.0);//caso seja insatisfatorio...
		System.out.println("retornou resultado business");
		return resultado;
	}
	
	
	
	
	//getters and setters
	
	public void setDesempenho(Desempenho desempenho) {
		this.desempenho = desempenho;
	}
	
	public void setEsforco(Esforco esforco) {
		this.esforco = esforco;
	}

	public void setLogin(LoginDTO login) {
		this.login = login;
		regraModel = new STIRegraModel(this.login); 
	}
	
	

}
