package validacao;

import java.util.Iterator;
import java.util.List;

import javax.servlet.http.HttpServletRequest;

import org.apache.commons.fileupload.FileItem;
import org.apache.commons.fileupload.FileItemFactory;
import org.apache.commons.fileupload.disk.DiskFileItemFactory;
import org.apache.commons.fileupload.servlet.ServletFileUpload;

import validacao.apoio.ApoioConfiguracao;
import validacao.message.MessageErrorConfiguracao;

public class ValidacaoCamposConfiguracao {

	public static void validaConfiguracao(HttpServletRequest req, MessageErrorConfiguracao mec)
			throws Exception {

		FileItemFactory factory = new DiskFileItemFactory();

		ServletFileUpload upload = new ServletFileUpload(factory);
		String altImagem = null;
		String titleImagem = null;
		String nomeImagem = null;

		List items = upload.parseRequest(req);
		Iterator iter = items.iterator();
		boolean erro = false;
		while (iter.hasNext()) {
			FileItem item = (FileItem) iter.next();
			if (item.getFieldName().equals("altImagem")) {
				altImagem = item.getString();
				try {
					if (altImagem.equalsIgnoreCase("")) {//nao informou o nome
						throw new Exception();
					}
				} catch (Exception e) {
					mec.setMessagemErroAltImagem("Valor de alt Invlido");
					erro = true;
				}
			} else if (item.getFieldName().equals("titleImagem")) {
				titleImagem = item.getString();
				try {
					if (titleImagem.equalsIgnoreCase("")) {//nao informou o nome
						throw new Exception();
					}
				} catch (Exception e) {
					mec.setMessagemErroTitleImagem("Valor de title Invlido");
					erro = true;
				}
			} else if (!item.isFormField()) {
				if (!(item.getName().length() > 0)) {
					nomeImagem = item.getString();
					try {
						if (nomeImagem.equalsIgnoreCase("")) {//nao informou o nome
							throw new Exception();
						}
					} catch (Exception e) {
						mec.setMessagemErroImagem("Imagem Invlida");
						erro = true;
					}
				}
			}
		}

		if (erro == true) {
			loadCursoApoio(req,nomeImagem,altImagem,titleImagem);
			throw new Exception();
		}
	}

	private static void loadCursoApoio(HttpServletRequest req, String nomeImagem, String altImagem, String titleImagem) {
		ApoioConfiguracao ap = new ApoioConfiguracao();
		ap.setNomeImagem(nomeImagem);
		ap.setAltImagem(altImagem);
		ap.setTitleImagem(titleImagem);
		req.setAttribute("apoio", ap);
	}
}