package validacao;

import javax.servlet.http.HttpServletRequest;

import validacao.apoio.ApoioConteudo;
import validacao.message.MessageErrorConteudo;

public class ValidacaoCamposConteudo {
	
	public static void validaConteudo(HttpServletRequest req,MessageErrorConteudo mec) throws Exception{
		boolean erro = false;
		try {//campo descricao
			if(req.getParameter("descricao").equalsIgnoreCase("")){//nao informou o nome
				throw new Exception();
			}
		}catch (Exception e) {
			mec.setMessagemErroDescricao("Descrio Invlido");
			erro = true;
		}
		try {//campo disciplina
			if(req.getParameter("idDisciplina").equalsIgnoreCase("")){//nao informou o nome
				throw new Exception();
			}
		}catch (Exception e) {
			mec.setMessagemErroDisciplina("Disciplina Invlida");
			erro = true;
		}
		try {//campo monitoria
			Integer monitoria = new Integer(req.getParameter("monitoria"));
			if(monitoria.intValue()<0)
				throw new Exception();
		}catch (RuntimeException r) {
			mec.setMessagemErroMonitoria("Somente nmero!!");
			erro = true;
		}catch (Exception e) {
			mec.setMessagemErroMonitoria("Monitoria Invlida");
			erro = true;
		}
		try {//campo questao
			Integer questoes = new Integer(req.getParameter("questoes"));
			if(questoes.intValue()<0)
				throw new Exception();
		}catch (RuntimeException r) {
			mec.setMessagemErroQuestoes("Somente nmero!!");
			erro = true;
		}catch (Exception e) {
			mec.setMessagemErroQuestoes("Questoes Invlida");
			erro = true;
		}
		if(erro){
			loadConteudoApoio(req);
			throw new Exception();
		}
	}
	private static void loadConteudoApoio(HttpServletRequest req){
		ApoioConteudo ac = new ApoioConteudo();
		ac.setDescricao(req.getParameter("descricao"));
		ac.setIdConteudo(req.getParameter("idConteudo"));
		ac.setIdDisciplina(req.getParameter("idDisciplina"));
		ac.setMonitoria(req.getParameter("monitoria"));
		ac.setQuestoes(req.getParameter("questoes"));
		req.setAttribute("apoio",ac);
	}
}
