package validacao;

import javax.servlet.http.HttpServletRequest;

import validacao.apoio.ApoioDisciplina;
import validacao.message.MessageErrorDisciplina;

public class ValidacaoCamposDisciplina {
	
	public static void validaDisciplina(HttpServletRequest req,MessageErrorDisciplina mec) throws Exception{
		boolean erro = false;
		try {//campo nome
			if(req.getParameter("nomeDisciplina").equalsIgnoreCase("")){//nao informou o nome
				throw new Exception();
			}
		}catch (Exception e) {
			mec.setMessagemErroNomeDisciplina("Nome Invlido");
			erro = true;
		}
		try {//campo objetivo
			if(req.getParameter("objetivo").equalsIgnoreCase("")){//nao informou o nome
				throw new Exception();
			}
		}catch (Exception e) {
			mec.setMessagemErroObjetivo("Objetivo Invlido");
			erro = true;
		}
		try {//campo carga horaria
			if(req.getParameter("cargaHoraria").equalsIgnoreCase("")){//nao informou o nome
				throw new Exception();
			}
		}catch (Exception e) {
			mec.setMessagemErroCargaHoraria("Carga Horria Invlido");
			erro = true;
		}
		try {
			Integer nivelMedio = new Integer(req.getParameter("nivel"));
			if(!(nivelMedio.intValue()>0 && nivelMedio.intValue() <= 10))
				throw new Exception();
		}catch (Exception e) {
			mec.setMessagemErroNivel("Nvel Invlido - Informe valores de 1 at 10");
			erro = true;
		}
						
		if(erro == true){
			loadDisciplinaApoio(req);
			throw new Exception();
		}
	}
	private static void loadDisciplinaApoio(HttpServletRequest req){
		ApoioDisciplina ad = new ApoioDisciplina();
		ad.setIdDisciplina(req.getParameter("idDisciplina"));
		ad.setNomeDisciplina(req.getParameter("nomeDisciplina"));
		ad.setObjetivo(req.getParameter("objetivo"));
		ad.setCargaHoraria(req.getParameter("cargaHoraria"));
		ad.setNivel(req.getParameter("nivel"));
		req.setAttribute("apoio",ad);
	}
}
