package validacao;

import java.sql.Date;
import java.text.SimpleDateFormat;

import validacao.apoio.ApoioMonitor;
import validacao.message.MessageErrorMonitor;

public class ValidacaoCamposMonitor {
	public static void validaMonitor(ApoioMonitor  am,MessageErrorMonitor mem) throws Exception{
		boolean erro = false;
		try {//campo de data de registro
			if(!am.getDtRegistro().equalsIgnoreCase("")){	
				SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
				java.util.Date dt = sdf.parse(am.getDtRegistro());
				new Date(dt.getTime());
			}	
		}catch (Exception e) {
			mem.setMessageErrorDtRegistro("Data invalida");
			erro = true;
		}
		try {//campo de data saida
			if(!am.getDtSaida().equalsIgnoreCase("indeterminada") && ! am.getDtSaida().equalsIgnoreCase("")){
				SimpleDateFormat sdf = new SimpleDateFormat("dd/MM/yyyy");
				java.util.Date dt = sdf.parse(am.getDtSaida());
				new Date(dt.getTime());
				
			}
			
		}catch (Exception e) {
			mem.setMessageErrorDtSaida("Data invalida");
			erro = true;
		}
		try {//campo ano
			Integer ano = new Integer(am.getAno());
			if(ano.intValue() < 1990)
				throw new Exception();
		}catch (Exception e) {
			mem.setMessageErrorAno("Ano Invalido");
			erro = true;
		}
		try {//campo semestre
			Integer semestre = new Integer(am.getSemestre());
			if(semestre.intValue() != 1 && semestre.intValue() != 2)
				throw new Exception();
		}catch (Exception e) {
			mem.setMessageErrorSemestre("Semestre Invalido");
			erro = true;
		}
		if(erro == true){
			
			throw new Exception();
		}
	}
}
