package validacao;

import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Iterator;
import java.util.LinkedHashSet;

import javax.servlet.http.HttpServletRequest;

import model.ConteudoModel;
import dto.ConteudoDTO;
import dto.LoginDTO;

public class ValidacaoOrdenamentoConteudo {
	public static Collection verificaOrdemDosConteudos(HttpServletRequest req) throws Exception{
		Enumeration e = req.getParameterNames();
		Collection values = new LinkedHashSet();//no vai aceitar values iguais e mantem a ordem
		Collection conteudos = getConteudosDaBase(req);
		Collection idsConteudo = new ArrayList();
		String name ="";
		Integer value = null;
		String []intervalo =  new String[conteudos.size()];
		initIntervalo(intervalo,conteudos);
		while(e.hasMoreElements()){
			name = e.nextElement().toString();//name do form (id conteudo)
			try {
				
				if(!name.equalsIgnoreCase("idDisciplina") && !name.equalsIgnoreCase("contexto")){//campo hiddem do idDisciplina
					idsConteudo.add(new Integer(name));//pega os ids do form
					value = new Integer(req.getParameter(name));//value do form
					System.out.println("["+name+"]["+value+"]");
				}
			} catch (NumberFormatException number) {
				req.setAttribute("mensagem","Tem que informar numero para ordenamento..");
				throw new NumberFormatException();
			}
			if(value != null && value.intValue()<=0){
				req.setAttribute("mensagem","Informe somente numeros maiores que zero!!");
				throw new Exception();
			}
			if(value != null && !isNoIntervalo(value,intervalo)){//se no estiver no intervalo
				req.setAttribute("mensagem","Informe somente numeros de 1 at "+intervalo.length+"!!");
				throw new Exception();
			}
				
			if(value!=null)
				values.add(value.toString());//usa hashcode de string
		}

		if(values.size()<conteudos.size()){
			req.setAttribute("mensagem","No pode ter conteudos com 'ordenamento' iguais!!!");
			throw new Exception();
		}else{
			return geraCollectionDeDTO(values,idsConteudo);
		}

	}
	private static Collection geraCollectionDeDTO(Collection values, Collection idsConteudos) {
		ConteudoDTO dto = null;
		String value = null;
		Integer idConteudo = null;
		Collection conteudos = new ArrayList();
		for (Iterator iter = values.iterator(),iterCont = idsConteudos.iterator(); iter.hasNext();) {
			 value = (String) iter.next();
			 idConteudo = (Integer)iterCont.next();
			 dto = new ConteudoDTO();
			 dto.setIdConteudo(idConteudo);
			 dto.setOrdem(new Integer(value));
   	  	 System.out.println("Id "+dto.getIdConteudo());
			 System.out.println("Ordem "+dto.getOrdem());
			 conteudos.add(dto);
		}
		return conteudos;
	}
	private static Collection getConteudosDaBase(HttpServletRequest req) throws SQLException{
		LoginDTO login = (LoginDTO)req.getSession().getAttribute("loginDTO");
		ConteudoModel model = new ConteudoModel(login);
		Collection conteudos = new ArrayList();
		Integer idDisciplina = new Integer(req.getParameter("idDisciplina"));
		try {
			conteudos = model.buscarConteudosPorDisciplinaUsandoDTO(idDisciplina);
		} catch (SQLException e) {
			throw new SQLException();
		}
		return conteudos;
	}
	private static void initIntervalo(String[] intervalo,Collection conteudosDaBase){
		for (int i = 0; i < intervalo.length; i++) {
			intervalo[i] = new String(new Integer(i+1).toString());
		}
	}
	private static boolean isNoIntervalo(Integer value,String[] intervalo){
		for (int i = 0; i < intervalo.length; i++) 
			if(new Integer(intervalo[i]).intValue() == value.intValue())
				return true;
		return false;
	}
}
